/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.images;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.WeakHashMap;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.stage.Stage;

public abstract class ImageUtils {
    static final String NODE_ICONS_DIR = "nodeicons";
    static final String UI_DIR = "ui";
    static final String MISSING_ICON = "MissingIcon.png";
    static final String CLOSED_HAND = "ClosedHand.png";
    static final String OPEN_HAND = "OpenHand.png";
    static final String WARNING_BADGE = "WarningBadge.png";
    static final String CSS_CURSOR = "css-cursor.png";
    private static Cursor closed_hand_cursor;
    private static Cursor open_hand_cursor;
    private static Image warning_badge_image;
    private static ImageCursor css_cursor;
    private static final WeakHashMap<String, Reference<Image>> imageCache;

    public static Image getImage(URL resource) {
        String imageUrl;
        Reference<Image> ref;
        Image image;
        if (resource == null) {
            resource = ImageUtils.class.getResource("nodeicons/MissingIcon.png");
        }
        Image image2 = image = (ref = imageCache.get(imageUrl = resource.toExternalForm())) != null ? ref.get() : null;
        if (image == null) {
            image = new Image(imageUrl);
            imageCache.put(imageUrl, new SoftReference<Image>(image));
        }
        return image;
    }

    public static Image getNodeIcon(String name) {
        URL resource = ImageUtils.getNodeIconURL(name);
        return ImageUtils.getImage(resource);
    }

    public static Image getImageFromNode(Node visualNode) {
        visualNode.setOpacity(0.75);
        Group visualGroup = new Group();
        visualGroup.getChildren().add((Object)visualNode);
        Scene hiddenScene = new Scene((Parent)visualGroup);
        Stage hiddenStage = new Stage();
        hiddenStage.setScene(hiddenScene);
        WritableImage contentImage = visualNode.snapshot(null, null);
        hiddenScene.setRoot((Parent)new Group());
        hiddenStage.close();
        return contentImage;
    }

    public static synchronized Cursor getClosedHandCursor() {
        if (closed_hand_cursor == null) {
            URL url = ImageUtils.class.getResource("ui/ClosedHand.png");
            closed_hand_cursor = new ImageCursor(new Image(url.toExternalForm()), 16.0, 10.0);
        }
        return closed_hand_cursor;
    }

    public static synchronized Cursor getOpenHandCursor() {
        if (open_hand_cursor == null) {
            URL url = ImageUtils.class.getResource("ui/OpenHand.png");
            open_hand_cursor = new ImageCursor(new Image(url.toExternalForm()), 16.0, 10.0);
        }
        return open_hand_cursor;
    }

    public static synchronized Image getWarningBadgeImage() {
        if (warning_badge_image == null) {
            URL url = ImageUtils.class.getResource("ui/WarningBadge.png");
            warning_badge_image = new Image(url.toExternalForm());
        }
        return warning_badge_image;
    }

    public static synchronized Cursor getCSSCursor() {
        if (css_cursor == null) {
            URL url = ImageUtils.class.getResource("ui/css-cursor.png");
            css_cursor = new ImageCursor(new Image(url.toExternalForm()));
        }
        return css_cursor;
    }

    public static URL getNodeIconURL(String name) {
        return ImageUtils.class.getResource("nodeicons/" + name);
    }

    static {
        imageCache = new WeakHashMap();
    }
}

