/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ReIndexObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.ArrayList;
import java.util.List;

public abstract class ArrangeZOrderJob
extends Job {
    protected final List<ReIndexObjectJob> subJobs = new ArrayList<ReIndexObjectJob>();
    protected String description;
    private AdjustAllToggleGroupJob adjustToggleGroups;

    public ArrangeZOrderJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public boolean isExecutable() {
        return !this.subJobs.isEmpty();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (ReIndexObjectJob subJob : this.subJobs) {
            subJob.execute();
        }
        this.adjustToggleGroups = new AdjustAllToggleGroupJob(this.getEditorController());
        this.adjustToggleGroups.execute();
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        assert (this.adjustToggleGroups != null);
        this.adjustToggleGroups.undo();
        for (int i = this.subJobs.size() - 1; i >= 0; --i) {
            this.subJobs.get(i).undo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (ReIndexObjectJob subJob : this.subJobs) {
            subJob.redo();
        }
        assert (this.adjustToggleGroups != null);
        this.adjustToggleGroups.redo();
        fxomDocument.endUpdate();
    }
}

