/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyFxIdJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.BackupSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;

public class BatchModifyFxIdJob
extends CompositeJob {
    private final FXOMObject fxomObject;
    private final String newValue;

    public BatchModifyFxIdJob(FXOMObject fxomObject, String newValue, EditorController editorController) {
        super(editorController, true, false);
        assert (fxomObject != null);
        this.fxomObject = fxomObject;
        this.newValue = newValue;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        ModifyFxIdJob job = new ModifyFxIdJob(this.fxomObject, this.newValue, this.getEditorController());
        if (job.isExecutable()) {
            result.add(job);
        }
        if (!result.isEmpty()) {
            result.add(0, new BackupSelectionJob(this.getEditorController()));
            result.add(new UpdateSelectionJob(this.fxomObject, this.getEditorController()));
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        List<Job> subJobs = this.getSubJobs();
        int subJobCount = subJobs.size();
        assert (subJobCount == 0 || subJobCount == 3);
        String result = subJobCount == 0 ? "Unexecutable Set" : subJobs.get(1).getDescription();
        return result;
    }
}

