/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.BackupSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchModifyObjectJob
extends CompositeJob {
    private final FXOMInstance fxomInstance;
    private final Map<ValuePropertyMetadata, Object> valueMap;
    private final String description;

    public BatchModifyObjectJob(FXOMInstance fxomInstance, String description, Map<ValuePropertyMetadata, Object> valueMap, EditorController editorController) {
        super(editorController, true, false);
        assert (fxomInstance != null);
        assert (valueMap != null);
        assert (description != null);
        this.fxomInstance = fxomInstance;
        this.valueMap = new HashMap<ValuePropertyMetadata, Object>(valueMap);
        this.description = description;
    }

    public BatchModifyObjectJob(FXOMInstance fxomInstance, ValuePropertyMetadata propertyMetadata, Object newValue, EditorController editorController) {
        super(editorController, true, false);
        assert (fxomInstance != null);
        assert (propertyMetadata != null);
        this.fxomInstance = fxomInstance;
        this.valueMap = new HashMap<ValuePropertyMetadata, Object>();
        this.valueMap.put(propertyMetadata, newValue);
        this.description = I18N.getString("label.action.edit.set.1", propertyMetadata.getName().toString(), fxomInstance.getSceneGraphObject().getClass().getSimpleName());
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        for (Map.Entry<ValuePropertyMetadata, Object> e : this.valueMap.entrySet()) {
            ModifyObjectJob j = new ModifyObjectJob(this.fxomInstance, e.getKey(), e.getValue(), this.getEditorController());
            if (!j.isExecutable()) continue;
            result.add(j);
        }
        if (!result.isEmpty()) {
            result.add(0, new BackupSelectionJob(this.getEditorController()));
            result.add(new UpdateSelectionJob(this.fxomInstance, this.getEditorController()));
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.description;
    }
}

