/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.DeleteColumnJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.DeleteRowJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class DeleteGridSelectionJob
extends Job {
    private Job subJob;
    private AbstractSelectionGroup selectionSnapshot;

    public DeleteGridSelectionJob(EditorController editorController) {
        super(editorController);
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null && this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        Selection selection = this.getEditorController().getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        assert (asg instanceof GridSelectionGroup);
        GridSelectionGroup gsg = (GridSelectionGroup)asg;
        FXOMObject targetGridPane = gsg.getParentObject();
        try {
            this.selectionSnapshot = selection.getGroup().clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
        selection.clear();
        selection.beginUpdate();
        this.subJob.execute();
        selection.select(targetGridPane);
        selection.endUpdate();
    }

    @Override
    public void undo() {
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        this.subJob.undo();
        selection.select(this.selectionSnapshot);
        selection.endUpdate();
    }

    @Override
    public void redo() {
        Selection selection = this.getEditorController().getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        assert (asg instanceof GridSelectionGroup);
        GridSelectionGroup gsg = (GridSelectionGroup)asg;
        FXOMObject targetGridPane = gsg.getParentObject();
        selection.clear();
        selection.beginUpdate();
        this.subJob.redo();
        selection.select(targetGridPane);
        selection.endUpdate();
    }

    @Override
    public String getDescription() {
        return this.subJob.getDescription();
    }

    private void buildSubJobs() {
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof GridSelectionGroup);
        GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
        switch (gsg.getType()) {
            case COLUMN: {
                this.subJob = new DeleteColumnJob(this.getEditorController());
                break;
            }
            case ROW: {
                this.subJob = new DeleteRowJob(this.getEditorController());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

