/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.RemovePropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import javafx.scene.chart.Axis;

public class DeleteObjectJob
extends Job {
    private final FXOMObject targetFxomObject;
    private String description;
    private BatchJob subJob;

    public DeleteObjectJob(FXOMObject fxomObject, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        this.targetFxomObject = fxomObject;
    }

    @Override
    public boolean isExecutable() {
        boolean result = this.targetFxomObject == this.targetFxomObject.getFxomDocument().getFxomRoot() ? true : (this.targetFxomObject.getSceneGraphObject() instanceof Axis ? false : this.targetFxomObject.getParentProperty() != null);
        return result;
    }

    @Override
    public void execute() {
        assert (this.subJob == null);
        this.subJob = new BatchJob(this.getEditorController(), true, null);
        if (this.targetFxomObject.getParentProperty() == null) {
            this.subJob.addSubJob(new SetDocumentRootJob(null, this.getEditorController()));
        } else {
            FXOMPropertyC parentProperty = this.targetFxomObject.getParentProperty();
            FXOMInstance parentInstance = parentProperty.getParentInstance();
            if (parentProperty.getValues().size() == 1 && parentInstance != null) {
                RemovePropertyJob removePropJob = new RemovePropertyJob(this.targetFxomObject.getParentProperty(), this.getEditorController());
                this.subJob.addSubJob(removePropJob);
            }
            RemovePropertyValueJob removeValueJob = new RemovePropertyValueJob(this.targetFxomObject, this.getEditorController());
            this.subJob.addSubJob(removeValueJob);
        }
        this.subJob.execute();
        assert (this.targetFxomObject.getParentProperty() == null);
    }

    @Override
    public void undo() {
        assert (this.subJob != null);
        this.subJob.undo();
    }

    @Override
    public void redo() {
        assert (this.subJob != null);
        this.getEditorController().getSelection().clear();
        this.subJob.redo();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Delete ");
            if (this.targetFxomObject instanceof FXOMInstance) {
                Object sceneGraphObject = this.targetFxomObject.getSceneGraphObject();
                if (sceneGraphObject != null) {
                    sb.append(sceneGraphObject.getClass().getSimpleName());
                } else {
                    sb.append("Unresolved Object");
                }
            } else if (this.targetFxomObject instanceof FXOMCollection) {
                sb.append("Collection");
            } else if (this.targetFxomObject instanceof FXOMIntrinsic) {
                sb.append(this.targetFxomObject.getGlueElement().getTagName());
            } else {
                assert (false);
                sb.append(this.targetFxomObject.getClass().getSimpleName());
            }
            this.description = sb.toString();
        }
        return this.description;
    }

    FXOMObject getTargetFxomObject() {
        return this.targetFxomObject;
    }
}

