/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.ClearSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;

public class DeleteObjectSelectionJob
extends CompositeJob {
    public DeleteObjectSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        ArrayList<Job> result = new ArrayList<Job>();
        result.add(new ClearSelectionJob(this.getEditorController()));
        int cannotDeleteCount = 0;
        for (FXOMObject candidate : osg.getFlattenItems()) {
            DeleteObjectJob subJob = new DeleteObjectJob(candidate, this.getEditorController());
            if (subJob.isExecutable()) {
                result.add(subJob);
                continue;
            }
            ++cannotDeleteCount;
        }
        result.add(new AdjustAllToggleGroupJob(this.getEditorController()));
        if (cannotDeleteCount >= 1) {
            result.clear();
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result;
        List<Job> subJobs = this.getSubJobs();
        int subJobCount = subJobs.size();
        assert (subJobCount == 0 || subJobCount >= 2);
        switch (subJobCount) {
            case 0: {
                result = "Unexecutable Delete";
                break;
            }
            case 2: {
                result = subJobs.get(1).getDescription();
                break;
            }
            default: {
                result = I18N.getString("label.action.edit.delete.n", subJobCount - 1);
            }
        }
        return result;
    }
}

