/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.RelocateNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.ClearSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;

public class DuplicateSelectionJob
extends CompositeJob {
    private static final double offset = 10.0;
    private int numOfDuplicatedObjects = 0;

    public DuplicateSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.canDuplicate()) {
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof ObjectSelectionGroup);
            ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
            assert (osg.hasSingleParent());
            FXOMObject targetObject = osg.getAncestor();
            assert (targetObject != null);
            FXOMDocument targetDocument = this.getEditorController().getFxomDocument();
            HashMap<FXOMObject, FXOMObject> newFxomObjects = new HashMap<FXOMObject, FXOMObject>();
            for (FXOMObject selectedObject : osg.getItems()) {
                FXOMDocument newDocument = FXOMNodes.newDocument(selectedObject);
                FXOMObject newObject = newDocument.getFxomRoot();
                newObject.moveToFxomDocument(targetDocument);
                assert (newDocument.getFxomRoot() == null);
                newFxomObjects.put(selectedObject, newObject);
            }
            assert (!newFxomObjects.isEmpty());
            DesignHierarchyMask targetMask = new DesignHierarchyMask(targetObject);
            if (targetMask.isAcceptingSubComponent(newFxomObjects.keySet())) {
                result.add(new ClearSelectionJob(this.getEditorController()));
                for (Map.Entry entry : newFxomObjects.entrySet()) {
                    FXOMObject selectedFxomObject = (FXOMObject)entry.getKey();
                    FXOMObject newFxomObject = (FXOMObject)entry.getValue();
                    InsertAsSubComponentJob insertSubJob = new InsertAsSubComponentJob(newFxomObject, targetObject, targetMask.getSubComponentCount(), this.getEditorController());
                    result.add(insertSubJob);
                    ++this.numOfDuplicatedObjects;
                    Object selectedSceneGraphObject = selectedFxomObject.getSceneGraphObject();
                    if (!(selectedSceneGraphObject instanceof Node)) continue;
                    Node selectedNode = (Node)selectedSceneGraphObject;
                    double newLayoutX = Math.round(selectedNode.getLayoutX() + 10.0);
                    double newLayoutY = Math.round(selectedNode.getLayoutY() + 10.0);
                    assert (newFxomObject instanceof FXOMInstance);
                    RelocateNodeJob relocateSubJob = new RelocateNodeJob((FXOMInstance)newFxomObject, newLayoutX, newLayoutY, this.getEditorController());
                    result.add(relocateSubJob);
                }
                result.add(new AdjustAllToggleGroupJob(this.getEditorController()));
                result.add(new UpdateSelectionJob(newFxomObjects.values(), this.getEditorController()));
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        assert (!this.getSubJobs().isEmpty());
        String result = this.numOfDuplicatedObjects == 1 ? this.makeSingleSelectionDescription() : this.makeMultipleSelectionDescription();
        return result;
    }

    private boolean canDuplicate() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (fxomDocument == null) {
            return false;
        }
        Selection selection = this.getEditorController().getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        FXOMObject rootObject = fxomDocument.getFxomRoot();
        if (selection.isSelected(rootObject)) {
            return false;
        }
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        for (FXOMObject fxomObject : osg.getItems()) {
            if (fxomObject.getSceneGraphObject() != null) continue;
            return false;
        }
        return osg.hasSingleParent();
    }

    private String makeSingleSelectionDescription() {
        String result;
        Job subJob0 = this.getSubJobs().get(1);
        assert (subJob0 instanceof InsertAsSubComponentJob);
        InsertAsSubComponentJob insertJob = (InsertAsSubComponentJob)subJob0;
        FXOMObject newObject = insertJob.getNewObject();
        if (newObject instanceof FXOMInstance) {
            Object sceneGraphObject = newObject.getSceneGraphObject();
            result = sceneGraphObject != null ? I18N.getString("label.action.edit.duplicate.1", sceneGraphObject.getClass().getSimpleName()) : I18N.getString("label.action.edit.duplicate.unresolved");
        } else if (newObject instanceof FXOMCollection) {
            result = I18N.getString("label.action.edit.duplicate.collection");
        } else {
            assert (false);
            result = I18N.getString("label.action.edit.duplicate.1", newObject.getClass().getSimpleName());
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        return I18N.getString("label.action.edit.duplicate.n", this.numOfDuplicatedObjects);
    }
}

