/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImportFileJob
extends CompositeJob {
    private final File file;
    private FXOMObject targetObject;

    public ImportFileJob(File file, EditorController editorController) {
        super(editorController, true, false);
        assert (file != null);
        this.file = file;
    }

    public FXOMObject getTargetObject() {
        return this.targetObject;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        FXOMDocument targetDocument = this.getEditorController().getFxomDocument();
        try {
            FXOMObject newObject = FXOMNodes.newObject(targetDocument, this.file);
            if (newObject != null) {
                FXOMObject rootObject = targetDocument.getFxomRoot();
                if (rootObject == null) {
                    result.add(new SetDocumentRootJob(newObject, this.getEditorController()));
                    result.add(new UpdateSelectionJob(newObject, this.getEditorController()));
                } else {
                    Selection selection = this.getEditorController().getSelection();
                    this.targetObject = selection.isEmpty() || selection.isSelected(rootObject) ? rootObject : selection.getAncestor();
                    DesignHierarchyMask targetMask = new DesignHierarchyMask(this.targetObject);
                    if (targetMask.isAcceptingSubComponent(newObject)) {
                        result.add(new InsertAsSubComponentJob(newObject, this.targetObject, targetMask.getSubComponentCount(), this.getEditorController()));
                        result.add(new UpdateSelectionJob(newObject, this.getEditorController()));
                    }
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("import.from.file", this.file.getName());
    }
}

