/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.util.URLUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class IncludeFileJob
extends CompositeJob {
    private final File file;
    private FXOMObject targetObject;

    public IncludeFileJob(File file, EditorController editorController) {
        super(editorController, true, false);
        assert (file != null);
        this.file = file;
    }

    public FXOMObject getTargetObject() {
        return this.targetObject;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        try {
            FXOMObject rootObject;
            FXOMIntrinsic newInclude;
            FXOMDocument targetDocument = this.getEditorController().getFxomDocument();
            URL documentURL = this.getEditorController().getFxmlLocation();
            URL fileURL = this.file.toURI().toURL();
            if (documentURL != null && !URLUtils.equals(documentURL, fileURL) && (newInclude = FXOMNodes.newInclude(targetDocument, this.file)) != null && (rootObject = targetDocument.getFxomRoot()) != null) {
                Selection selection = this.getEditorController().getSelection();
                this.targetObject = selection.isEmpty() || selection.isSelected(rootObject) ? rootObject : selection.getAncestor();
                DesignHierarchyMask targetMask = new DesignHierarchyMask(this.targetObject);
                if (targetMask.isAcceptingSubComponent(newInclude)) {
                    result.add(new InsertAsSubComponentJob(newInclude, this.targetObject, targetMask.getSubComponentCount(), this.getEditorController()));
                    result.add(new UpdateSelectionJob(newInclude, this.getEditorController()));
                }
            }
        }
        catch (IOException ex) {
            result.clear();
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("include.file", this.file.getName());
    }
}

