/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.PrunePropertiesJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;

public class InsertAsAccessoryJob
extends Job {
    private final FXOMObject newObject;
    private final FXOMObject targetObject;
    private final DesignHierarchyMask.Accessory accessory;
    private BatchJob subJob;
    private String description;

    public InsertAsAccessoryJob(FXOMObject newObject, FXOMObject targetObject, DesignHierarchyMask.Accessory accessory, EditorController editorController) {
        super(editorController);
        assert (newObject != null);
        assert (targetObject != null);
        assert (accessory != null);
        assert (newObject.getFxomDocument() == this.getEditorController().getFxomDocument());
        assert (targetObject.getFxomDocument() == this.getEditorController().getFxomDocument());
        this.newObject = newObject;
        this.targetObject = targetObject;
        this.accessory = accessory;
    }

    @Override
    public boolean isExecutable() {
        DesignHierarchyMask mask;
        boolean result = this.targetObject instanceof FXOMInstance ? (mask = new DesignHierarchyMask(this.targetObject)).isAcceptingAccessory(this.accessory, this.newObject) && mask.getAccessory(this.accessory) == null : false;
        return result;
    }

    @Override
    public void execute() {
        PrunePropertiesJob pruneJob;
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        FXOMInstance targetInstance = (FXOMInstance)this.targetObject;
        DesignHierarchyMask mask = new DesignHierarchyMask(this.targetObject);
        PropertyName accessoryName = mask.getPropertyNameForAccessory(this.accessory);
        assert (accessoryName != null);
        FXOMPropertyC targetProperty = new FXOMPropertyC(fxomDocument, accessoryName);
        this.subJob = new BatchJob(this.getEditorController(), true, null);
        AddPropertyValueJob addValueJob = new AddPropertyValueJob(this.newObject, targetProperty, -1, this.getEditorController());
        this.subJob.addSubJob(addValueJob);
        if (targetProperty.getParentInstance() == null) {
            assert (this.targetObject instanceof FXOMInstance);
            AddPropertyJob addPropertyJob = new AddPropertyJob(targetProperty, targetInstance, -1, this.getEditorController());
            this.subJob.addSubJob(addPropertyJob);
        }
        if (((Job)(pruneJob = new PrunePropertiesJob(this.newObject, this.targetObject, this.getEditorController()))).isExecutable()) {
            this.subJob.prependSubJob(pruneJob);
        }
        this.subJob.execute();
    }

    @Override
    public void undo() {
        assert (this.subJob != null);
        this.subJob.undo();
    }

    @Override
    public void redo() {
        assert (this.subJob != null);
        this.subJob.redo();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Insert ");
            if (this.newObject instanceof FXOMInstance) {
                Object sceneGraphObject = this.newObject.getSceneGraphObject();
                if (sceneGraphObject != null) {
                    sb.append(sceneGraphObject.getClass().getSimpleName());
                } else {
                    sb.append("Unresolved Object");
                }
            } else if (this.newObject instanceof FXOMCollection) {
                sb.append("Collection");
            } else {
                assert (false);
                sb.append(this.newObject.getClass().getSimpleName());
            }
            this.description = sb.toString();
        }
        return this.description;
    }
}

