/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.util.Objects;

public class ModifyFxIdJob
extends Job {
    private final FXOMObject fxomObject;
    private final String newValue;
    private final String oldValue;

    public ModifyFxIdJob(FXOMObject fxomObject, String newValue, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        assert (fxomObject.getSceneGraphObject() != null);
        this.fxomObject = fxomObject;
        this.newValue = newValue;
        this.oldValue = fxomObject.getFxId();
    }

    @Override
    public boolean isExecutable() {
        return !Objects.equals(this.oldValue, this.newValue) && (this.newValue == null || JavaLanguage.isIdentifier(this.newValue));
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        this.getEditorController().getFxomDocument().beginUpdate();
        this.fxomObject.setFxId(this.oldValue);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (Objects.equals(this.fxomObject.getFxId(), this.oldValue));
    }

    @Override
    public void redo() {
        this.getEditorController().getFxomDocument().beginUpdate();
        this.fxomObject.setFxId(this.newValue);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (Objects.equals(this.fxomObject.getFxId(), this.newValue));
    }

    @Override
    public String getDescription() {
        String result;
        if (this.newValue == null) {
            assert (this.oldValue != null);
            result = I18N.getString("job.remove.fxid", this.oldValue);
        } else {
            result = I18N.getString("job.set.fxid", this.newValue);
        }
        return result;
    }
}

