/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import java.util.Objects;

public class ModifyObjectJob
extends Job {
    private final FXOMInstance fxomInstance;
    private final ValuePropertyMetadata propertyMetadata;
    private final Object newValue;
    private final Object oldValue;

    public ModifyObjectJob(FXOMInstance fxomInstance, ValuePropertyMetadata propertyMetadata, Object newValue, EditorController editorController) {
        super(editorController);
        assert (fxomInstance != null);
        assert (fxomInstance.getSceneGraphObject() != null);
        assert (propertyMetadata != null);
        this.fxomInstance = fxomInstance;
        this.propertyMetadata = propertyMetadata;
        this.newValue = newValue;
        this.oldValue = propertyMetadata.getValueObject(fxomInstance);
    }

    @Override
    public boolean isExecutable() {
        Object currentValue = this.propertyMetadata.getValueObject(this.fxomInstance);
        return !Objects.equals(this.newValue, currentValue);
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        this.getEditorController().getFxomDocument().beginUpdate();
        this.propertyMetadata.setValueObject(this.fxomInstance, this.oldValue);
        this.getEditorController().getFxomDocument().endUpdate();
    }

    @Override
    public void redo() {
        this.getEditorController().getFxomDocument().beginUpdate();
        this.propertyMetadata.setValueObject(this.fxomInstance, this.newValue);
        this.getEditorController().getFxomDocument().endUpdate();
    }

    @Override
    public String getDescription() {
        String description = I18N.getString("label.action.edit.set.1", this.propertyMetadata.getName().toString(), this.fxomInstance.getSceneGraphObject().getClass().getSimpleName());
        return description;
    }
}

