/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.ClearSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardDecoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.input.Clipboard;

public class PasteIntoJob
extends CompositeJob {
    public PasteIntoJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (fxomDocument != null) {
            FXOMObject targetObject;
            DesignHierarchyMask targetMask;
            ObjectSelectionGroup osg;
            ClipboardDecoder clipboardDecoder = new ClipboardDecoder(Clipboard.getSystemClipboard());
            List<FXOMObject> newObjects = clipboardDecoder.decode(fxomDocument);
            Selection selection = this.getEditorController().getSelection();
            if (selection.getGroup() instanceof ObjectSelectionGroup && (osg = (ObjectSelectionGroup)selection.getGroup()).getItems().size() == 1 && (targetMask = new DesignHierarchyMask(targetObject = osg.getItems().iterator().next())).isAcceptingSubComponent(newObjects)) {
                result.add(new ClearSelectionJob(this.getEditorController()));
                for (FXOMObject newObject : newObjects) {
                    InsertAsSubComponentJob subJob = new InsertAsSubComponentJob(newObject, targetObject, targetMask.getSubComponentCount(), this.getEditorController());
                    result.add(subJob);
                }
                result.add(new AdjustAllToggleGroupJob(this.getEditorController()));
                result.add(new UpdateSelectionJob(newObjects, this.getEditorController()));
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result = this.getSubJobs().size() == 3 ? this.makeSingleSelectionDescription() : this.makeMultipleSelectionDescription();
        return result;
    }

    private String makeSingleSelectionDescription() {
        String result;
        assert (this.getSubJobs().size() == 3);
        Job subJob0 = this.getSubJobs().get(1);
        assert (subJob0 instanceof InsertAsSubComponentJob);
        InsertAsSubComponentJob insertJob = (InsertAsSubComponentJob)subJob0;
        FXOMObject newObject = insertJob.getNewObject();
        if (newObject instanceof FXOMInstance) {
            Object sceneGraphObject = newObject.getSceneGraphObject();
            result = sceneGraphObject != null ? I18N.getString("label.action.edit.paste.into.1", sceneGraphObject.getClass().getSimpleName()) : I18N.getString("label.action.edit.paste.into.unresolved");
        } else if (newObject instanceof FXOMCollection) {
            result = I18N.getString("label.action.edit.paste.into.collection");
        } else {
            assert (false);
            result = I18N.getString("label.action.edit.paste.into.1", newObject.getClass().getSimpleName());
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        int objectCount = this.getSubJobs().size() - 2;
        return I18N.getString("label.action.edit.paste.into.n", objectCount);
    }
}

