/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.InsertAsSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.RelocateNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.ClearSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.ClipboardDecoder;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.Clipboard;

public class PasteJob
extends CompositeJob {
    private final List<Job> insertJobs = new ArrayList<Job>();
    private FXOMObject targetObject;

    public PasteJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (fxomDocument != null) {
            ClipboardDecoder clipboardDecoder = new ClipboardDecoder(Clipboard.getSystemClipboard());
            List<FXOMObject> newObjects = clipboardDecoder.decode(fxomDocument);
            assert (newObjects != null);
            if (!newObjects.isEmpty()) {
                if (fxomDocument.getFxomRoot() == null) {
                    this.targetObject = null;
                } else {
                    Selection selection = this.getEditorController().getSelection();
                    FXOMObject rootObject = fxomDocument.getFxomRoot();
                    this.targetObject = selection.isEmpty() || selection.isSelected(rootObject) ? rootObject : selection.getAncestor();
                }
                assert (this.targetObject != null || fxomDocument.getFxomRoot() == null);
                if (this.targetObject == null) {
                    if (newObjects.size() == 1) {
                        result.add(new ClearSelectionJob(this.getEditorController()));
                        FXOMObject newObject0 = newObjects.get(0);
                        SetDocumentRootJob subJob = new SetDocumentRootJob(newObject0, this.getEditorController());
                        result.add(subJob);
                        result.add(new AdjustAllToggleGroupJob(this.getEditorController()));
                        result.add(new UpdateSelectionJob(newObject0, this.getEditorController()));
                        this.insertJobs.add(subJob);
                    }
                } else {
                    DesignHierarchyMask targetMask = new DesignHierarchyMask(this.targetObject);
                    if (targetMask.isAcceptingSubComponent(newObjects)) {
                        double relocateDelta;
                        if (targetMask.isFreeChildPositioning()) {
                            int pasteJobCount = this.countPasteJobs();
                            relocateDelta = 10.0 * (double)(pasteJobCount + 1);
                        } else {
                            relocateDelta = 0.0;
                        }
                        result.add(new ClearSelectionJob(this.getEditorController()));
                        for (FXOMObject newObject : newObjects) {
                            InsertAsSubComponentJob subJob = new InsertAsSubComponentJob(newObject, this.targetObject, targetMask.getSubComponentCount(), this.getEditorController());
                            result.add(subJob);
                            this.insertJobs.add(subJob);
                            if (relocateDelta == 0.0 || !newObject.isNode()) continue;
                            Node sceneGraphNode = (Node)newObject.getSceneGraphObject();
                            RelocateNodeJob relocateJob = new RelocateNodeJob((FXOMInstance)newObject, sceneGraphNode.getLayoutX() + relocateDelta, sceneGraphNode.getLayoutY() + relocateDelta, this.getEditorController());
                            result.add(relocateJob);
                        }
                        result.add(new AdjustAllToggleGroupJob(this.getEditorController()));
                        result.add(new UpdateSelectionJob(newObjects, this.getEditorController()));
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result = this.insertJobs.size() == 1 ? this.makeSingleSelectionDescription() : this.makeMultipleSelectionDescription();
        return result;
    }

    private String makeSingleSelectionDescription() {
        String result;
        FXOMObject newObject;
        assert (this.insertJobs.size() == 1);
        Job subJob0 = this.insertJobs.get(0);
        if (subJob0 instanceof InsertAsSubComponentJob) {
            InsertAsSubComponentJob insertJob = (InsertAsSubComponentJob)subJob0;
            newObject = insertJob.getNewObject();
        } else {
            assert (subJob0 instanceof SetDocumentRootJob);
            SetDocumentRootJob setRootJob = (SetDocumentRootJob)subJob0;
            newObject = setRootJob.getNewRoot();
        }
        if (newObject instanceof FXOMInstance) {
            Object sceneGraphObject = newObject.getSceneGraphObject();
            result = sceneGraphObject != null ? I18N.getString("label.action.edit.paste.1", sceneGraphObject.getClass().getSimpleName()) : I18N.getString("label.action.edit.paste.unresolved");
        } else if (newObject instanceof FXOMCollection) {
            result = I18N.getString("label.action.edit.paste.collection");
        } else {
            assert (false);
            result = I18N.getString("label.action.edit.paste.1", newObject.getClass().getSimpleName());
        }
        return result;
    }

    private String makeMultipleSelectionDescription() {
        int objectCount = this.insertJobs.size();
        return I18N.getString("label.action.edit.paste.n", objectCount);
    }

    private int countPasteJobs() {
        int result = 0;
        List<Job> undoStack = this.getEditorController().getJobManager().getUndoStack();
        for (Job job : undoStack) {
            if (!(job instanceof PasteJob)) break;
            PasteJob pasteJob = (PasteJob)job;
            if (this.targetObject != pasteJob.targetObject) break;
            ++result;
        }
        return result;
    }
}

