/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class ReIndexObjectJob
extends Job {
    private final FXOMObject reindexedObject;
    private final FXOMObject beforeObject;
    private final FXOMObject oldBeforeObject;
    private String description;

    public ReIndexObjectJob(FXOMObject reindexedObject, FXOMObject beforeObject, EditorController editorController) {
        super(editorController);
        assert (reindexedObject != null);
        this.reindexedObject = reindexedObject;
        this.beforeObject = beforeObject;
        this.oldBeforeObject = reindexedObject.getNextSlibing();
    }

    @Override
    public boolean isExecutable() {
        return this.beforeObject != this.oldBeforeObject;
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.reindexedObject.moveBeforeSibling(this.oldBeforeObject);
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.reindexedObject.moveBeforeSibling(this.beforeObject);
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Move ");
            if (this.reindexedObject instanceof FXOMInstance) {
                Object sceneGraphObject = this.reindexedObject.getSceneGraphObject();
                if (sceneGraphObject != null) {
                    sb.append(sceneGraphObject.getClass().getSimpleName());
                } else {
                    sb.append("Unresolved Object");
                }
            } else if (this.reindexedObject instanceof FXOMCollection) {
                sb.append("Collection");
            } else {
                assert (false);
                sb.append(this.reindexedObject.getClass().getSimpleName());
            }
            this.description = sb.toString();
        }
        return this.description;
    }
}

