/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.driver.relocater.AnchorPaneRelocater;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.DoublePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;

public class RelocateNodeJob
extends Job {
    private final FXOMInstance fxomInstance;
    private double oldLayoutX;
    private double oldLayoutY;
    private Double oldLeftAnchor;
    private Double oldRightAnchor;
    private Double oldTopAnchor;
    private Double oldBottomAnchor;
    private double newLayoutX;
    private double newLayoutY;
    private Double newLeftAnchor;
    private Double newRightAnchor;
    private Double newTopAnchor;
    private Double newBottomAnchor;
    private final DoublePropertyMetadata layoutXMeta;
    private final DoublePropertyMetadata layoutYMeta;
    private final DoublePropertyMetadata leftAnchorMeta;
    private final DoublePropertyMetadata rightAnchorMeta;
    private final DoublePropertyMetadata topAnchorMeta;
    private final DoublePropertyMetadata bottomAnchorMeta;

    public RelocateNodeJob(FXOMInstance fxomInstance, double newLayoutX, double newLayoutY, EditorController editorController) {
        super(editorController);
        assert (fxomInstance != null);
        assert (fxomInstance.getSceneGraphObject() instanceof Node);
        this.fxomInstance = fxomInstance;
        this.newLayoutX = newLayoutX;
        this.newLayoutY = newLayoutY;
        Metadata metadata = Metadata.getMetadata();
        Class<?> sgoClass = fxomInstance.getSceneGraphObject().getClass();
        PropertyName layoutXName = new PropertyName("layoutX");
        PropertyName layoutYName = new PropertyName("layoutY");
        PropertyName leftAnchorName = new PropertyName("leftAnchor", AnchorPane.class);
        PropertyName rightAnchorName = new PropertyName("rightAnchor", AnchorPane.class);
        PropertyName topAnchorName = new PropertyName("topAnchor", AnchorPane.class);
        PropertyName bottomAnchorName = new PropertyName("bottomAnchor", AnchorPane.class);
        this.layoutXMeta = (DoublePropertyMetadata)metadata.queryProperty(sgoClass, layoutXName);
        this.layoutYMeta = (DoublePropertyMetadata)metadata.queryProperty(sgoClass, layoutYName);
        this.leftAnchorMeta = (DoublePropertyMetadata)metadata.queryProperty(sgoClass, leftAnchorName);
        this.rightAnchorMeta = (DoublePropertyMetadata)metadata.queryProperty(sgoClass, rightAnchorName);
        this.topAnchorMeta = (DoublePropertyMetadata)metadata.queryProperty(sgoClass, topAnchorName);
        this.bottomAnchorMeta = (DoublePropertyMetadata)metadata.queryProperty(sgoClass, bottomAnchorName);
    }

    public FXOMInstance getFxomInstance() {
        return this.fxomInstance;
    }

    public double getNewLayoutX() {
        return this.newLayoutX;
    }

    public double getNewLayoutY() {
        return this.newLayoutY;
    }

    public void mergeWith(RelocateNodeJob youngerJob) {
        assert (!MathUtils.equals(this.newLayoutX, youngerJob.newLayoutX) || !MathUtils.equals(this.newLayoutY, youngerJob.newLayoutY));
        this.newLayoutX = youngerJob.newLayoutX;
        this.newLayoutY = youngerJob.newLayoutY;
        this.updateNewAnchors();
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute() {
        this.oldLayoutX = (Double)this.layoutXMeta.getValue(this.fxomInstance);
        this.oldLayoutY = (Double)this.layoutYMeta.getValue(this.fxomInstance);
        this.oldLeftAnchor = (Double)this.leftAnchorMeta.getValue(this.fxomInstance);
        this.oldRightAnchor = (Double)this.rightAnchorMeta.getValue(this.fxomInstance);
        this.oldTopAnchor = (Double)this.topAnchorMeta.getValue(this.fxomInstance);
        this.oldBottomAnchor = (Double)this.bottomAnchorMeta.getValue(this.fxomInstance);
        this.updateNewAnchors();
        this.redo();
    }

    @Override
    public void undo() {
        this.layoutXMeta.setValue(this.fxomInstance, this.oldLayoutX);
        this.layoutYMeta.setValue(this.fxomInstance, this.oldLayoutY);
        if (this.oldLeftAnchor != null) {
            this.leftAnchorMeta.setValue(this.fxomInstance, this.oldLeftAnchor);
        }
        if (this.oldRightAnchor != null) {
            this.rightAnchorMeta.setValue(this.fxomInstance, this.oldRightAnchor);
        }
        if (this.oldTopAnchor != null) {
            this.topAnchorMeta.setValue(this.fxomInstance, this.oldTopAnchor);
        }
        if (this.oldBottomAnchor != null) {
            this.bottomAnchorMeta.setValue(this.fxomInstance, this.oldBottomAnchor);
        }
    }

    @Override
    public void redo() {
        this.layoutXMeta.setValue(this.fxomInstance, this.newLayoutX);
        this.layoutYMeta.setValue(this.fxomInstance, this.newLayoutY);
        if (this.newLeftAnchor != null) {
            this.leftAnchorMeta.setValue(this.fxomInstance, this.newLeftAnchor);
        }
        if (this.newRightAnchor != null) {
            this.rightAnchorMeta.setValue(this.fxomInstance, this.newRightAnchor);
        }
        if (this.newTopAnchor != null) {
            this.topAnchorMeta.setValue(this.fxomInstance, this.newTopAnchor);
        }
        if (this.newBottomAnchor != null) {
            this.bottomAnchorMeta.setValue(this.fxomInstance, this.newBottomAnchor);
        }
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }

    private void updateNewAnchors() {
        Bounds parentLayoutBounds;
        Bounds nodeLayoutBounds;
        Node sceneGraphNode;
        if (this.oldLeftAnchor == null && this.oldRightAnchor == null) {
            this.newLeftAnchor = null;
            this.newRightAnchor = null;
        } else {
            sceneGraphNode = (Node)this.fxomInstance.getSceneGraphObject();
            nodeLayoutBounds = sceneGraphNode.getLayoutBounds();
            parentLayoutBounds = sceneGraphNode.getParent().getLayoutBounds();
            this.newLeftAnchor = this.oldLeftAnchor != null ? Double.valueOf(AnchorPaneRelocater.computeLeftAnchor(parentLayoutBounds, nodeLayoutBounds, this.newLayoutX)) : null;
            this.newRightAnchor = this.oldRightAnchor != null ? Double.valueOf(AnchorPaneRelocater.computeRightAnchor(parentLayoutBounds, nodeLayoutBounds, this.newLayoutX)) : null;
        }
        if (this.oldTopAnchor == null && this.oldBottomAnchor == null) {
            this.newTopAnchor = null;
            this.newBottomAnchor = null;
        } else {
            sceneGraphNode = (Node)this.fxomInstance.getSceneGraphObject();
            nodeLayoutBounds = sceneGraphNode.getLayoutBounds();
            parentLayoutBounds = sceneGraphNode.getParent().getLayoutBounds();
            this.newTopAnchor = this.oldTopAnchor != null ? Double.valueOf(AnchorPaneRelocater.computeTopAnchor(parentLayoutBounds, nodeLayoutBounds, this.newLayoutY)) : null;
            this.newBottomAnchor = this.oldBottomAnchor != null ? Double.valueOf(AnchorPaneRelocater.computeBottomAnchor(parentLayoutBounds, nodeLayoutBounds, this.newLayoutY)) : null;
        }
    }
}

