/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.RelocateNodeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Point2D;

public class RelocateSelectionJob
extends CompositeJob {
    private static final long MERGE_PERIOD = 1000L;
    private final Map<FXOMObject, Point2D> locationMap = new HashMap<FXOMObject, Point2D>();
    private long time = System.currentTimeMillis();

    public RelocateSelectionJob(Map<FXOMObject, Point2D> locationMap, EditorController editorController) {
        super(editorController);
        this.locationMap.putAll(locationMap);
    }

    public boolean canBeMergedWith(Job other) {
        boolean result;
        if (other instanceof RelocateSelectionJob) {
            RelocateSelectionJob otherRelocate = (RelocateSelectionJob)other;
            long timeDifference = otherRelocate.time - this.time;
            if (0L <= timeDifference && timeDifference < 1000L) {
                Set<FXOMObject> thisKeys = this.locationMap.keySet();
                Set<FXOMObject> otherKeys = otherRelocate.locationMap.keySet();
                result = thisKeys.equals(otherKeys);
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public void mergeWith(Job younger) {
        assert (this.canBeMergedWith(younger));
        assert (younger instanceof RelocateSelectionJob);
        RelocateSelectionJob youngerSelection = (RelocateSelectionJob)younger;
        for (Job subJob : this.getSubJobs()) {
            assert (subJob instanceof RelocateNodeJob);
            RelocateNodeJob thisRelocateJob = (RelocateNodeJob)subJob;
            RelocateNodeJob youngerRelocateJob = youngerSelection.lookupSubJob(thisRelocateJob.getFxomInstance());
            thisRelocateJob.mergeWith(youngerRelocateJob);
        }
        this.time = youngerSelection.time;
    }

    public RelocateNodeJob lookupSubJob(FXOMObject fxomObject) {
        RelocateNodeJob result = null;
        for (Job subJob : this.getSubJobs()) {
            assert (subJob instanceof RelocateNodeJob);
            RelocateNodeJob relocateJob = (RelocateNodeJob)subJob;
            if (relocateJob.getFxomInstance() != fxomObject) continue;
            result = relocateJob;
            break;
        }
        return result;
    }

    public static boolean isSelectionMovable(EditorController editorController) {
        boolean result;
        Selection selection = editorController.getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            if (osg.hasSingleParent()) {
                FXOMObject parent = osg.getAncestor();
                DesignHierarchyMask m = new DesignHierarchyMask(parent);
                result = m.isFreeChildPositioning();
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        for (Map.Entry<FXOMObject, Point2D> entry : this.locationMap.entrySet()) {
            assert (entry.getKey() instanceof FXOMInstance);
            FXOMInstance fxomInstance = (FXOMInstance)entry.getKey();
            Point2D layoutXY = entry.getValue();
            RelocateNodeJob relocateJob = new RelocateNodeJob(fxomInstance, layoutXY.getX(), layoutXY.getY(), this.getEditorController());
            result.add(relocateJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        String result;
        Set<FXOMObject> movedObjects = this.locationMap.keySet();
        if (this.locationMap.size() == 1) {
            FXOMObject movedObject = movedObjects.iterator().next();
            Object sceneGraphObject = movedObject.getSceneGraphObject();
            result = sceneGraphObject == null ? I18N.getString("drop.job.move.single.unresolved") : I18N.getString("drop.job.move.single.resolved", sceneGraphObject.getClass().getSimpleName());
        } else {
            boolean homogeneous;
            HashSet classes = new HashSet();
            int unresolvedCount = 0;
            for (FXOMObject o : movedObjects) {
                if (o.getSceneGraphObject() != null) {
                    classes.add(o.getSceneGraphObject().getClass());
                    continue;
                }
                ++unresolvedCount;
            }
            boolean bl = homogeneous = classes.size() == 1 && unresolvedCount == 0;
            if (homogeneous) {
                Class singleClass = (Class)classes.iterator().next();
                result = I18N.getString("drop.job.move.multiple.homogeneous", movedObjects.size(), singleClass.getSimpleName());
            } else {
                result = I18N.getString("drop.job.move.multiple.heterogeneous", movedObjects.size());
            }
        }
        return result;
    }
}

