/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.ArrangeZOrderJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ReIndexObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.HashSet;

public class SendBackwardJob
extends ArrangeZOrderJob {
    public SendBackwardJob(EditorController editorController) {
        super(editorController);
        this.buildSubJobs();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.buildDescription();
        }
        return this.description;
    }

    private void buildSubJobs() {
        HashSet<FXOMObject> candidates = new HashSet<FXOMObject>();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            candidates.addAll(osg.getFlattenItems());
        } else if (!(selection.getGroup() instanceof GridSelectionGroup)) assert (selection.getGroup() == null) : "Add implementation for " + selection.getGroup();
        for (FXOMObject candidate : candidates) {
            ReIndexObjectJob subJob;
            FXOMObject previousSlibing = candidate.getPreviousSlibing();
            if (previousSlibing == null || !(subJob = new ReIndexObjectJob(candidate, previousSlibing, this.getEditorController())).isExecutable()) continue;
            this.subJobs.add(subJob);
        }
    }

    private void buildDescription() {
        switch (this.subJobs.size()) {
            case 0: {
                this.description = "Unexecutable Send Backward";
                break;
            }
            case 1: {
                this.description = ((ReIndexObjectJob)this.subJobs.get(0)).getDescription();
                break;
            }
            default: {
                this.description = this.makeMultipleSelectionDescription();
            }
        }
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Send Backward ");
        result.append(this.subJobs.size());
        result.append(" Objects");
        return result.toString();
    }
}

