/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.PrunePropertiesJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class SetDocumentRootJob
extends Job {
    private final FXOMObject newRoot;
    private FXOMObject oldRoot;
    private Job trimJob;

    public SetDocumentRootJob(FXOMObject newRoot, EditorController editorController) {
        super(editorController);
        assert (editorController.getFxomDocument() != null);
        assert (newRoot == null || newRoot.getFxomDocument() == editorController.getFxomDocument());
        this.newRoot = newRoot;
    }

    public FXOMObject getNewRoot() {
        return this.newRoot;
    }

    @Override
    public boolean isExecutable() {
        return this.newRoot != this.getEditorController().getFxomDocument().getFxomRoot();
    }

    @Override
    public void execute() {
        assert (this.oldRoot == null);
        assert (this.trimJob == null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        this.oldRoot = fxomDocument.getFxomRoot();
        if (this.newRoot != null) {
            this.trimJob = new PrunePropertiesJob(this.newRoot, null, this.getEditorController());
            if (!this.trimJob.isExecutable()) {
                this.trimJob = null;
            }
        }
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        if (this.trimJob != null) {
            this.trimJob.execute();
        }
        fxomDocument.setFxomRoot(this.newRoot);
        fxomDocument.endUpdate();
        selection.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        assert (fxomDocument.getFxomRoot() == this.newRoot);
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        fxomDocument.setFxomRoot(this.oldRoot);
        if (this.trimJob != null) {
            this.trimJob.undo();
        }
        fxomDocument.endUpdate();
        selection.endUpdate();
        assert (fxomDocument.getFxomRoot() == this.oldRoot);
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        assert (fxomDocument.getFxomRoot() == this.oldRoot);
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        if (this.trimJob != null) {
            this.trimJob.redo();
        }
        fxomDocument.setFxomRoot(this.newRoot);
        fxomDocument.endUpdate();
        selection.endUpdate();
        assert (fxomDocument.getFxomRoot() == this.newRoot);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

