/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;

public class ToggleFxRootJob
extends Job {
    public ToggleFxRootJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public boolean isExecutable() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        return fxomDocument != null && fxomDocument.getFxomRoot() instanceof FXOMInstance;
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        this.redo();
    }

    @Override
    public void redo() {
        assert (this.getEditorController().getFxomDocument() != null);
        assert (this.getEditorController().getFxomDocument().getFxomRoot() instanceof FXOMInstance);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        FXOMInstance rootInstance = (FXOMInstance)fxomDocument.getFxomRoot();
        rootInstance.toggleFxRoot();
    }

    @Override
    public String getDescription() {
        return I18N.getString("job.toggle.fx.root");
    }
}

