/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ToggleFxRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.ClearSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMFxIdIndex;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class TrimSelectionJob
extends Job {
    private BatchJob batchJob;

    public TrimSelectionJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public boolean isExecutable() {
        FXOMDocument fxomDocument;
        FXOMObject fxomObject;
        ObjectSelectionGroup osg;
        Selection selection = this.getEditorController().getSelection();
        boolean result = selection.getGroup() instanceof ObjectSelectionGroup ? ((osg = (ObjectSelectionGroup)selection.getGroup()).getItems().size() == 1 ? ((fxomObject = osg.getItems().iterator().next()) instanceof FXOMInstance ? fxomObject != (fxomDocument = fxomObject.getFxomDocument()).getFxomRoot() && FXOMFxIdIndex.isSelfContainedObject(fxomObject) : false) : false) : false;
        return result;
    }

    @Override
    public void execute() {
        assert (this.batchJob == null);
        assert (this.isExecutable());
        Selection selection = this.getEditorController().getSelection();
        assert (selection.getGroup() instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
        assert (osg.getItems().size() == 1);
        FXOMObject oldRoot = this.getEditorController().getFxomDocument().getFxomRoot();
        FXOMObject candidateRoot = osg.getItems().iterator().next();
        this.batchJob = new BatchJob(this.getEditorController());
        assert (oldRoot instanceof FXOMInstance);
        boolean isFxRoot = ((FXOMInstance)oldRoot).isFxRoot();
        String fxController = oldRoot.getFxController();
        if (isFxRoot) {
            ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
            this.batchJob.addSubJob(fxRootJob);
        }
        if (fxController != null) {
            ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(oldRoot, null, this.getEditorController());
            this.batchJob.addSubJob(fxControllerJob);
        }
        ClearSelectionJob clearSelectionJob = new ClearSelectionJob(this.getEditorController());
        this.batchJob.addSubJob(clearSelectionJob);
        DeleteObjectJob deleteNewRoot = new DeleteObjectJob(candidateRoot, this.getEditorController());
        this.batchJob.addSubJob(deleteNewRoot);
        SetDocumentRootJob setDocumentRoot = new SetDocumentRootJob(candidateRoot, this.getEditorController());
        this.batchJob.addSubJob(setDocumentRoot);
        AdjustAllToggleGroupJob adjustToggleGroups = new AdjustAllToggleGroupJob(this.getEditorController());
        this.batchJob.addSubJob(adjustToggleGroups);
        if (isFxRoot) {
            ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
            this.batchJob.addSubJob(fxRootJob);
        }
        if (fxController != null) {
            ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(candidateRoot, fxController, this.getEditorController());
            this.batchJob.addSubJob(fxControllerJob);
        }
        this.batchJob.execute();
    }

    @Override
    public void undo() {
        assert (this.batchJob != null);
        this.batchJob.undo();
    }

    @Override
    public void redo() {
        assert (this.batchJob != null);
        this.batchJob.redo();
    }

    @Override
    public String getDescription() {
        return I18N.getString("label.action.edit.trim");
    }
}

