/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;

public class UseComputedSizesObjectJob
extends Job {
    private final FXOMInstance fxomInstance;
    private final List<BatchModifyObjectJob> subJobs = new ArrayList<BatchModifyObjectJob>();
    private String description;

    public UseComputedSizesObjectJob(FXOMInstance fxomInstance, EditorController editorController) {
        super(editorController);
        assert (fxomInstance != null);
        this.fxomInstance = fxomInstance;
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return !this.subJobs.isEmpty();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (BatchModifyObjectJob subJob : this.subJobs) {
            subJob.execute();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (int i = this.subJobs.size() - 1; i >= 0; --i) {
            this.subJobs.get(i).undo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (BatchModifyObjectJob subJob : this.subJobs) {
            subJob.redo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Use Computed Sizes on ");
            Object sceneGraphObject = this.fxomInstance.getSceneGraphObject();
            assert (sceneGraphObject != null);
            sb.append(sceneGraphObject.getClass().getSimpleName());
            this.description = sb.toString();
        }
        return this.description;
    }

    private void buildSubJobs() {
        Object sceneGraphObject = this.fxomInstance.getSceneGraphObject();
        if (sceneGraphObject instanceof RowConstraints) {
            this.subJobs.addAll(this.modifyHeightJobs(this.fxomInstance));
        } else if (sceneGraphObject instanceof ColumnConstraints) {
            this.subJobs.addAll(this.modifyWidthJobs(this.fxomInstance));
        } else if (sceneGraphObject instanceof Region) {
            this.subJobs.addAll(this.removeAnchorsJobs());
            this.subJobs.addAll(this.modifyHeightJobs(this.fxomInstance));
            this.subJobs.addAll(this.modifyWidthJobs(this.fxomInstance));
        } else if (sceneGraphObject instanceof ImageView) {
            this.subJobs.addAll(this.modifyFitHeightJob(this.fxomInstance));
            this.subJobs.addAll(this.modifyFitWidthJob(this.fxomInstance));
        }
    }

    private List<BatchModifyObjectJob> removeAnchorsJobs() {
        ArrayList<BatchModifyObjectJob> result = new ArrayList<BatchModifyObjectJob>();
        FXOMObject parentObject = this.fxomInstance.getParentObject();
        if (parentObject != null && parentObject.getSceneGraphObject() instanceof AnchorPane) {
            PropertyName topAnchorPN = new PropertyName("topAnchor", AnchorPane.class);
            ValuePropertyMetadata topAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, topAnchorPN);
            PropertyName rightAnchorPN = new PropertyName("rightAnchor", AnchorPane.class);
            ValuePropertyMetadata rightAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, rightAnchorPN);
            PropertyName bottomAnchorPN = new PropertyName("bottomAnchor", AnchorPane.class);
            ValuePropertyMetadata bottomAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, bottomAnchorPN);
            PropertyName leftAnchorPN = new PropertyName("leftAnchor", AnchorPane.class);
            ValuePropertyMetadata leftAnchorVPM = Metadata.getMetadata().queryValueProperty(this.fxomInstance, leftAnchorPN);
            for (ValuePropertyMetadata vpm : new ValuePropertyMetadata[]{topAnchorVPM, rightAnchorVPM, bottomAnchorVPM, leftAnchorVPM}) {
                if (vpm.getValueObject(this.fxomInstance) == null) continue;
                BatchModifyObjectJob subJob = new BatchModifyObjectJob(this.fxomInstance, vpm, null, this.getEditorController());
                result.add(subJob);
            }
        }
        return result;
    }

    private List<BatchModifyObjectJob> modifyHeightJobs(FXOMInstance candidate) {
        ArrayList<BatchModifyObjectJob> result = new ArrayList<BatchModifyObjectJob>();
        PropertyName maxHeight = new PropertyName("maxHeight");
        PropertyName minHeight = new PropertyName("minHeight");
        PropertyName prefHeight = new PropertyName("prefHeight");
        ValuePropertyMetadata maxHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, maxHeight);
        ValuePropertyMetadata minHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, minHeight);
        ValuePropertyMetadata prefHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, prefHeight);
        BatchModifyObjectJob maxHeightJob = new BatchModifyObjectJob(candidate, maxHeightVPM, -1.0, this.getEditorController());
        BatchModifyObjectJob minHeightJob = new BatchModifyObjectJob(candidate, minHeightVPM, -1.0, this.getEditorController());
        BatchModifyObjectJob prefHeightJob = new BatchModifyObjectJob(candidate, prefHeightVPM, -1.0, this.getEditorController());
        if (maxHeightJob.isExecutable()) {
            result.add(maxHeightJob);
        }
        if (minHeightJob.isExecutable()) {
            result.add(minHeightJob);
        }
        if (prefHeightJob.isExecutable()) {
            result.add(prefHeightJob);
        }
        return result;
    }

    private List<BatchModifyObjectJob> modifyWidthJobs(FXOMInstance candidate) {
        ArrayList<BatchModifyObjectJob> result = new ArrayList<BatchModifyObjectJob>();
        PropertyName maxWidth = new PropertyName("maxWidth");
        PropertyName minWidth = new PropertyName("minWidth");
        PropertyName prefWidth = new PropertyName("prefWidth");
        ValuePropertyMetadata maxWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, maxWidth);
        ValuePropertyMetadata minWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, minWidth);
        ValuePropertyMetadata prefWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, prefWidth);
        BatchModifyObjectJob maxWidthJob = new BatchModifyObjectJob(candidate, maxWidthVPM, -1.0, this.getEditorController());
        BatchModifyObjectJob minWidthJob = new BatchModifyObjectJob(candidate, minWidthVPM, -1.0, this.getEditorController());
        BatchModifyObjectJob prefWidthJob = new BatchModifyObjectJob(candidate, prefWidthVPM, -1.0, this.getEditorController());
        if (maxWidthJob.isExecutable()) {
            result.add(maxWidthJob);
        }
        if (minWidthJob.isExecutable()) {
            result.add(minWidthJob);
        }
        if (prefWidthJob.isExecutable()) {
            result.add(prefWidthJob);
        }
        return result;
    }

    private List<BatchModifyObjectJob> modifyFitHeightJob(FXOMInstance candidate) {
        ArrayList<BatchModifyObjectJob> result = new ArrayList<BatchModifyObjectJob>();
        PropertyName fitHeight = new PropertyName("fitHeight");
        ValuePropertyMetadata fitHeightVPM = Metadata.getMetadata().queryValueProperty(candidate, fitHeight);
        BatchModifyObjectJob fitHeightJob = new BatchModifyObjectJob(candidate, fitHeightVPM, 0.0, this.getEditorController());
        if (fitHeightJob.isExecutable()) {
            result.add(fitHeightJob);
        }
        return result;
    }

    private List<BatchModifyObjectJob> modifyFitWidthJob(FXOMInstance candidate) {
        ArrayList<BatchModifyObjectJob> result = new ArrayList<BatchModifyObjectJob>();
        PropertyName fitWidth = new PropertyName("fitWidth");
        ValuePropertyMetadata fitWidthVPM = Metadata.getMetadata().queryValueProperty(candidate, fitWidth);
        BatchModifyObjectJob fitWidthJob = new BatchModifyObjectJob(candidate, fitWidthVPM, 0.0, this.getEditorController());
        if (fitWidthJob.isExecutable()) {
            result.add(fitWidthJob);
        }
        return result;
    }
}

