/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.UseComputedSizesObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class UseComputedSizesSelectionJob
extends Job {
    private final List<UseComputedSizesObjectJob> subJobs = new ArrayList<UseComputedSizesObjectJob>();
    private String description;

    public UseComputedSizesSelectionJob(EditorController editorController) {
        super(editorController);
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return !this.subJobs.isEmpty();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (UseComputedSizesObjectJob subJob : this.subJobs) {
            subJob.execute();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (int i = this.subJobs.size() - 1; i >= 0; --i) {
            this.subJobs.get(i).undo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        for (UseComputedSizesObjectJob subJob : this.subJobs) {
            subJob.redo();
        }
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.buildDescription();
        }
        return this.description;
    }

    private void buildSubJobs() {
        HashSet<FXOMInstance> candidates = new HashSet<FXOMInstance>();
        Selection selection = this.getEditorController().getSelection();
        if (selection.getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject fxomObject : osg.getItems()) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                candidates.add((FXOMInstance)fxomObject);
            }
        } else if (selection.getGroup() instanceof GridSelectionGroup) {
            GridSelectionGroup gsg = (GridSelectionGroup)selection.getGroup();
            FXOMObject gridPane = gsg.getParentObject();
            DesignHierarchyMask mask = new DesignHierarchyMask(gridPane);
            for (int index : gsg.getIndexes()) {
                FXOMObject constraints;
                switch (gsg.getType()) {
                    case COLUMN: {
                        constraints = mask.getColumnConstraintsAtIndex(index);
                        break;
                    }
                    case ROW: {
                        constraints = mask.getRowConstraintsAtIndex(index);
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                assert (constraints instanceof FXOMInstance);
                candidates.add((FXOMInstance)constraints);
            }
        } else assert (selection.getGroup() == null) : "Add implementation for " + selection.getGroup();
        for (FXOMInstance candidate : candidates) {
            UseComputedSizesObjectJob subJob = new UseComputedSizesObjectJob(candidate, this.getEditorController());
            if (!subJob.isExecutable()) continue;
            this.subJobs.add(subJob);
        }
    }

    private void buildDescription() {
        switch (this.subJobs.size()) {
            case 0: {
                this.description = "Unexecutable Use Computed Sizes";
                break;
            }
            case 1: {
                this.description = this.subJobs.get(0).getDescription();
                break;
            }
            default: {
                this.description = this.makeMultipleSelectionDescription();
            }
        }
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Use Computed Sizes on ");
        result.append(this.subJobs.size());
        result.append(" Objects");
        return result.toString();
    }
}

