/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.List;
import java.util.Map;
import javafx.scene.layout.ColumnConstraints;

public class AddColumnConstraintsJob
extends Job {
    private BatchJob subJob;
    private final Map<FXOMObject, List<Integer>> targetGridPanes;
    private final GridPaneJobUtils.Position position;
    private static final double defaultMinWidth = 10.0;
    private static final double defaultPrefWidth = 100.0;

    public AddColumnConstraintsJob(EditorController editorController, GridPaneJobUtils.Position position, Map<FXOMObject, List<Integer>> targetGridPanes) {
        super(editorController);
        this.position = position;
        this.targetGridPanes = targetGridPanes;
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null && this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.execute();
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.undo();
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        return "Add Column Constraints";
    }

    private void buildSubJobs() {
        this.subJob = new BatchJob(this.getEditorController(), true, null);
        assert (!this.targetGridPanes.isEmpty());
        for (FXOMObject targetGridPane : this.targetGridPanes.keySet()) {
            assert (targetGridPane instanceof FXOMInstance);
            List<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            this.addColumnConstraints((FXOMInstance)targetGridPane, targetIndexes);
        }
    }

    private void addColumnConstraints(FXOMInstance targetGridPane, List<Integer> targetIndexes) {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        PropertyName propertyName = new PropertyName("columnConstraints");
        FXOMProperty constraintsProperty = targetGridPane.getProperties().get(propertyName);
        if (constraintsProperty == null) {
            constraintsProperty = new FXOMPropertyC(fxomDocument, propertyName);
        }
        assert (constraintsProperty instanceof FXOMPropertyC);
        DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
        int shiftIndex = 0;
        int constraintsSize = mask.getColumnsConstraintsSize();
        for (int targetIndex : targetIndexes) {
            AddPropertyValueJob addValueJob;
            FXOMInstance addedConstraints;
            FXOMObject targetConstraints;
            int addedIndex = targetIndex + shiftIndex;
            if (this.position == GridPaneJobUtils.Position.AFTER) {
                ++addedIndex;
            }
            if ((targetConstraints = mask.getColumnConstraintsAtIndex(targetIndex)) != null) {
                assert (targetConstraints instanceof FXOMInstance);
                addedConstraints = this.makeColumnConstraintsInstance((FXOMInstance)targetConstraints);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                this.subJob.addSubJob(addValueJob);
            } else {
                for (int index = constraintsSize; index < addedIndex; ++index) {
                    FXOMInstance addedConstraints2 = this.makeColumnConstraintsInstance();
                    AddPropertyValueJob addValueJob2 = new AddPropertyValueJob(addedConstraints2, (FXOMPropertyC)constraintsProperty, index, this.getEditorController());
                    this.subJob.addSubJob(addValueJob2);
                }
                addedConstraints = this.makeColumnConstraintsInstance();
                JobUtils.setMinWidth(addedConstraints, ColumnConstraints.class, 10.0);
                JobUtils.setPrefWidth(addedConstraints, ColumnConstraints.class, 100.0);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                this.subJob.addSubJob(addValueJob);
                constraintsSize = addedIndex + 1;
            }
            ++shiftIndex;
        }
        if (constraintsProperty.getParentInstance() == null) {
            AddPropertyJob addPropertyJob = new AddPropertyJob(constraintsProperty, targetGridPane, -1, this.getEditorController());
            this.subJob.addSubJob(addPropertyJob);
        }
    }

    private FXOMInstance makeColumnConstraintsInstance() {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, ColumnConstraints.class);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }

    private FXOMInstance makeColumnConstraintsInstance(FXOMInstance constraints) {
        assert (constraints != null);
        assert (constraints.getDeclaredClass() == ColumnConstraints.class);
        FXOMInstance result = this.makeColumnConstraintsInstance();
        boolean fillWidth = JobUtils.getFillWidth(constraints, ColumnConstraints.class);
        double maxWidth = JobUtils.getMaxWidth(constraints, ColumnConstraints.class);
        double minWidth = JobUtils.getMinWidth(constraints, ColumnConstraints.class);
        double percentWidth = JobUtils.getPercentWidth(constraints, ColumnConstraints.class);
        double prefWidth = JobUtils.getPrefWidth(constraints, ColumnConstraints.class);
        String halignment = JobUtils.getHAlignment(constraints, ColumnConstraints.class);
        String hgrow = JobUtils.getHGrow(constraints, ColumnConstraints.class);
        JobUtils.setFillWidth(result, ColumnConstraints.class, fillWidth);
        JobUtils.setMaxWidth(result, ColumnConstraints.class, maxWidth);
        JobUtils.setMinWidth(result, ColumnConstraints.class, Math.max(minWidth, 10.0));
        JobUtils.setPercentWidth(result, ColumnConstraints.class, percentWidth);
        JobUtils.setPrefWidth(result, ColumnConstraints.class, Math.max(prefWidth, 100.0));
        JobUtils.setHAlignment(result, ColumnConstraints.class, halignment);
        JobUtils.setHGrow(result, ColumnConstraints.class, hgrow);
        return result;
    }
}

