/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.AddColumnConstraintsJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.ReIndexColumnContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AddColumnJob
extends Job {
    private BatchJob subJob;
    private AbstractSelectionGroup selectionSnapshot;
    private final Map<FXOMObject, List<Integer>> targetGridPanes = new HashMap<FXOMObject, List<Integer>>();
    private final GridPaneJobUtils.Position position;

    public AddColumnJob(EditorController editorController, GridPaneJobUtils.Position position) {
        super(editorController);
        assert (position == GridPaneJobUtils.Position.BEFORE || position == GridPaneJobUtils.Position.AFTER);
        this.position = position;
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null && this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        assert (this.isExecutable());
        assert (!this.targetGridPanes.isEmpty());
        try {
            this.selectionSnapshot = selection.getGroup().clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.subJob.execute();
        fxomDocument.endUpdate();
        this.updateSelection();
        selection.endUpdate();
    }

    @Override
    public void undo() {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.subJob.undo();
        fxomDocument.endUpdate();
        selection.select(this.selectionSnapshot);
        selection.endUpdate();
    }

    @Override
    public void redo() {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        fxomDocument.endUpdate();
        this.updateSelection();
        selection.endUpdate();
    }

    @Override
    public String getDescription() {
        return "Add Column " + this.position.name();
    }

    private void buildSubJobs() {
        if (GridPaneJobUtils.canPerformAdd(this.getEditorController())) {
            this.subJob = new BatchJob(this.getEditorController(), true, null);
            assert (this.targetGridPanes.isEmpty());
            List<FXOMObject> objectList = GridPaneJobUtils.getTargetGridPanes(this.getEditorController());
            for (FXOMObject object : objectList) {
                List<Integer> indexList = this.getTargetColumnIndexes(this.getEditorController(), object);
                this.targetGridPanes.put(object, indexList);
            }
            AddColumnConstraintsJob addConstraints = new AddColumnConstraintsJob(this.getEditorController(), this.position, this.targetGridPanes);
            this.subJob.addSubJob(addConstraints);
            this.moveColumnContent();
        }
    }

    private void moveColumnContent() {
        assert (this.subJob != null);
        for (FXOMObject targetGridPane : this.targetGridPanes.keySet()) {
            List<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
            int columnsSize = mask.getColumnsSize();
            Iterator<Integer> iterator = targetIndexes.iterator();
            int shiftIndex = 0;
            int targetIndex = iterator.next();
            while (targetIndex != -1) {
                int toIndex;
                int fromIndex;
                switch (this.position) {
                    case BEFORE: {
                        fromIndex = targetIndex;
                        if (iterator.hasNext()) {
                            targetIndex = iterator.next();
                            toIndex = targetIndex - 1;
                            break;
                        }
                        targetIndex = -1;
                        toIndex = columnsSize - 1;
                        break;
                    }
                    case AFTER: {
                        fromIndex = targetIndex + 1;
                        if (iterator.hasNext()) {
                            toIndex = targetIndex = iterator.next().intValue();
                            break;
                        }
                        targetIndex = -1;
                        toIndex = columnsSize - 1;
                        break;
                    }
                    default: {
                        assert (false);
                        return;
                    }
                }
                if (fromIndex < columnsSize) {
                    int offset = 1 + shiftIndex;
                    List<Integer> indexes = GridPaneJobUtils.getIndexes(fromIndex, toIndex);
                    ReIndexColumnContentJob reIndexJob = new ReIndexColumnContentJob(this.getEditorController(), offset, targetGridPane, indexes);
                    this.subJob.addSubJob(reIndexJob);
                }
                ++shiftIndex;
            }
        }
    }

    private void updateSelection() {
        Selection selection = this.getEditorController().getSelection();
        if (this.targetGridPanes.size() > 1) {
            selection.select(this.targetGridPanes.keySet());
        } else {
            assert (this.targetGridPanes.size() == 1);
            FXOMInstance targetGridPane = (FXOMInstance)this.targetGridPanes.keySet().iterator().next();
            List<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            assert (targetIndexes.size() >= 1);
            List<Integer> addedIndexes = GridPaneJobUtils.getAddedIndexes(targetIndexes, this.position);
            assert (selection.isEmpty());
            for (int addedIndex : addedIndexes) {
                selection.toggleSelection(targetGridPane, GridSelectionGroup.Type.COLUMN, addedIndex);
            }
        }
    }

    private List<Integer> getTargetColumnIndexes(EditorController editorController, FXOMObject targetGridPane) {
        Selection selection = editorController.getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (asg instanceof GridSelectionGroup && ((GridSelectionGroup)asg).getType() == GridSelectionGroup.Type.COLUMN) {
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            result.addAll(gsg.getIndexes());
        } else {
            switch (this.position) {
                case BEFORE: {
                    result.add(0);
                    break;
                }
                case AFTER: {
                    DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
                    int size = mask.getColumnsSize();
                    result.add(size - 1);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return result;
    }
}

