/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.List;
import java.util.Map;
import javafx.scene.layout.RowConstraints;

public class AddRowConstraintsJob
extends Job {
    private BatchJob subJob;
    private final Map<FXOMObject, List<Integer>> targetGridPanes;
    private final GridPaneJobUtils.Position position;
    private static final double defaultMinHeight = 10.0;
    private static final double defaultPrefHeight = 30.0;

    public AddRowConstraintsJob(EditorController editorController, GridPaneJobUtils.Position position, Map<FXOMObject, List<Integer>> targetGridPanes) {
        super(editorController);
        this.position = position;
        this.targetGridPanes = targetGridPanes;
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null && this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.execute();
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.undo();
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        return "Add Row Constraints";
    }

    private void buildSubJobs() {
        this.subJob = new BatchJob(this.getEditorController(), true, null);
        assert (!this.targetGridPanes.isEmpty());
        for (FXOMObject targetGridPane : this.targetGridPanes.keySet()) {
            assert (targetGridPane instanceof FXOMInstance);
            List<Integer> targetIndexes = this.targetGridPanes.get(targetGridPane);
            this.addRowConstraints((FXOMInstance)targetGridPane, targetIndexes);
        }
    }

    private void addRowConstraints(FXOMInstance targetGridPane, List<Integer> targetIndexes) {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        PropertyName propertyName = new PropertyName("rowConstraints");
        FXOMProperty constraintsProperty = targetGridPane.getProperties().get(propertyName);
        if (constraintsProperty == null) {
            constraintsProperty = new FXOMPropertyC(fxomDocument, propertyName);
        }
        assert (constraintsProperty instanceof FXOMPropertyC);
        DesignHierarchyMask mask = new DesignHierarchyMask(targetGridPane);
        int shiftIndex = 0;
        int constraintsSize = mask.getRowsConstraintsSize();
        for (int targetIndex : targetIndexes) {
            AddPropertyValueJob addValueJob;
            FXOMInstance addedConstraints;
            FXOMObject targetConstraints;
            int addedIndex = targetIndex + shiftIndex;
            if (this.position == GridPaneJobUtils.Position.BELOW) {
                ++addedIndex;
            }
            if ((targetConstraints = mask.getRowConstraintsAtIndex(targetIndex)) != null) {
                assert (targetConstraints instanceof FXOMInstance);
                addedConstraints = this.makeRowConstraintsInstance((FXOMInstance)targetConstraints);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                this.subJob.addSubJob(addValueJob);
            } else {
                for (int index = constraintsSize; index < addedIndex; ++index) {
                    FXOMInstance addedConstraints2 = this.makeRowConstraintsInstance();
                    AddPropertyValueJob addValueJob2 = new AddPropertyValueJob(addedConstraints2, (FXOMPropertyC)constraintsProperty, index, this.getEditorController());
                    this.subJob.addSubJob(addValueJob2);
                }
                addedConstraints = this.makeRowConstraintsInstance();
                JobUtils.setMinHeight(addedConstraints, RowConstraints.class, 10.0);
                JobUtils.setPrefHeight(addedConstraints, RowConstraints.class, 30.0);
                addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, addedIndex, this.getEditorController());
                this.subJob.addSubJob(addValueJob);
                constraintsSize = addedIndex + 1;
            }
            ++shiftIndex;
        }
        if (constraintsProperty.getParentInstance() == null) {
            AddPropertyJob addPropertyJob = new AddPropertyJob(constraintsProperty, targetGridPane, -1, this.getEditorController());
            this.subJob.addSubJob(addPropertyJob);
        }
    }

    private FXOMInstance makeRowConstraintsInstance() {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, RowConstraints.class);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }

    private FXOMInstance makeRowConstraintsInstance(FXOMInstance constraints) {
        assert (constraints != null);
        assert (constraints.getDeclaredClass() == RowConstraints.class);
        FXOMInstance result = this.makeRowConstraintsInstance();
        boolean fillHeight = JobUtils.getFillHeight(constraints, RowConstraints.class);
        double maxHeight = JobUtils.getMaxHeight(constraints, RowConstraints.class);
        double minHeight = JobUtils.getMinHeight(constraints, RowConstraints.class);
        double percentHeight = JobUtils.getPercentHeight(constraints, RowConstraints.class);
        double prefHeight = JobUtils.getPrefHeight(constraints, RowConstraints.class);
        String valignment = JobUtils.getVAlignment(constraints, RowConstraints.class);
        String vgrow = JobUtils.getVGrow(constraints, RowConstraints.class);
        JobUtils.setFillHeight(result, RowConstraints.class, fillHeight);
        JobUtils.setMaxHeight(result, RowConstraints.class, maxHeight);
        JobUtils.setMinHeight(result, RowConstraints.class, Math.max(minHeight, 10.0));
        JobUtils.setPercentHeight(result, RowConstraints.class, percentHeight);
        JobUtils.setPrefHeight(result, RowConstraints.class, Math.max(prefHeight, 30.0));
        JobUtils.setVAlignment(result, RowConstraints.class, valignment);
        JobUtils.setVGrow(result, RowConstraints.class, vgrow);
        return result;
    }
}

