/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.ReIndexRowContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.RemoveRowConstraintsJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.RemoveRowContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteRowJob
extends Job {
    private BatchJob subJob;
    private FXOMObject targetGridPane;
    private final List<Integer> targetIndexes = new ArrayList<Integer>();
    private String description;

    public DeleteRowJob(EditorController editorController) {
        super(editorController);
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null && this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        assert (this.isExecutable());
        assert (!this.targetIndexes.isEmpty());
        fxomDocument.beginUpdate();
        this.subJob.execute();
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.undo();
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.buildDescription();
        }
        return this.description;
    }

    private void buildSubJobs() {
        if (GridPaneJobUtils.canPerformRemove(this.getEditorController())) {
            this.subJob = new BatchJob(this.getEditorController(), true, null);
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            this.targetGridPane = gsg.getParentObject();
            this.targetIndexes.addAll(gsg.getIndexes());
            RemoveRowConstraintsJob removeConstraints = new RemoveRowConstraintsJob(this.getEditorController(), this.targetGridPane, this.targetIndexes);
            this.subJob.addSubJob(removeConstraints);
            RemoveRowContentJob removeContent = new RemoveRowContentJob(this.getEditorController(), this.targetGridPane, this.targetIndexes);
            this.subJob.addSubJob(removeContent);
            this.subJob.addSubJob(new AdjustAllToggleGroupJob(this.getEditorController()));
            this.moveRowContent();
        }
    }

    private void moveRowContent() {
        assert (this.subJob != null);
        DesignHierarchyMask targetGridPaneMask = new DesignHierarchyMask(this.targetGridPane);
        int rowsSize = targetGridPaneMask.getRowsSize();
        Iterator<Integer> iterator = this.targetIndexes.iterator();
        int shiftIndex = 0;
        int targetIndex = iterator.next();
        while (targetIndex != -1) {
            int toIndex;
            int nextTargetIndex;
            int fromIndex = targetIndex + 1;
            if (iterator.hasNext()) {
                nextTargetIndex = iterator.next();
                toIndex = nextTargetIndex - 1;
            } else {
                nextTargetIndex = -1;
                toIndex = rowsSize - 1;
            }
            if (nextTargetIndex != targetIndex + 1 && fromIndex < rowsSize) {
                int offset = -1 + shiftIndex;
                List<Integer> indexes = GridPaneJobUtils.getIndexes(fromIndex, toIndex);
                ReIndexRowContentJob reIndexJob = new ReIndexRowContentJob(this.getEditorController(), offset, this.targetGridPane, indexes);
                this.subJob.addSubJob(reIndexJob);
            }
            targetIndex = nextTargetIndex;
            --shiftIndex;
        }
    }

    private void buildDescription() {
        switch (this.targetIndexes.size()) {
            case 0: {
                this.description = "Unexecutable Delete";
                break;
            }
            case 1: {
                this.description = "Delete Row";
                break;
            }
            default: {
                this.description = this.makeMultipleSelectionDescription();
            }
        }
    }

    private String makeMultipleSelectionDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Delete ");
        result.append(this.targetIndexes.size());
        result.append(" Rows");
        return result.toString();
    }
}

