/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.GridPaneJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.ReIndexRowContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.GridSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.RowConstraints;

public class MoveRowJob
extends Job {
    private BatchJob subJob;
    private AbstractSelectionGroup selectionSnapshot;
    private FXOMObject targetGridPane;
    private final List<Integer> targetIndexes = new ArrayList<Integer>();
    private final GridPaneJobUtils.Position position;

    public MoveRowJob(EditorController editorController, GridPaneJobUtils.Position position) {
        super(editorController);
        assert (position == GridPaneJobUtils.Position.ABOVE || position == GridPaneJobUtils.Position.BELOW);
        this.position = position;
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null && this.subJob.isExecutable();
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        assert (this.isExecutable());
        assert (!this.targetIndexes.isEmpty());
        try {
            this.selectionSnapshot = selection.getGroup().clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.subJob.execute();
        fxomDocument.endUpdate();
        this.updateSelection();
        selection.endUpdate();
    }

    @Override
    public void undo() {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.subJob.undo();
        fxomDocument.endUpdate();
        selection.select(this.selectionSnapshot);
        selection.endUpdate();
    }

    @Override
    public void redo() {
        assert (this.subJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        fxomDocument.endUpdate();
        this.updateSelection();
        selection.endUpdate();
    }

    @Override
    public String getDescription() {
        return "Move Row " + this.position.name();
    }

    private void buildSubJobs() {
        if (GridPaneJobUtils.canPerformMove(this.getEditorController(), this.position)) {
            this.subJob = new BatchJob(this.getEditorController(), true, null);
            Selection selection = this.getEditorController().getSelection();
            AbstractSelectionGroup asg = selection.getGroup();
            assert (asg instanceof GridSelectionGroup);
            GridSelectionGroup gsg = (GridSelectionGroup)asg;
            this.targetGridPane = gsg.getParentObject();
            this.targetIndexes.addAll(gsg.getIndexes());
            this.moveRowConstraints();
            this.moveRowContent();
        }
    }

    private void moveRowConstraints() {
        assert (this.subJob != null);
        PropertyName propertyName = new PropertyName("rowConstraints");
        assert (this.targetGridPane instanceof FXOMInstance);
        FXOMProperty constraintsProperty = ((FXOMInstance)this.targetGridPane).getProperties().get(propertyName);
        if (constraintsProperty == null) {
            return;
        }
        DesignHierarchyMask mask = new DesignHierarchyMask(this.targetGridPane);
        for (int targetIndex : this.targetIndexes) {
            FXOMObject aboveConstraints;
            int positionIndex;
            switch (this.position) {
                case ABOVE: {
                    positionIndex = targetIndex - 1;
                    break;
                }
                case BELOW: {
                    positionIndex = targetIndex + 1;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            FXOMObject targetConstraints = mask.getRowConstraintsAtIndex(targetIndex);
            if (targetConstraints != null) {
                DeleteObjectJob removeValueJob = new DeleteObjectJob(targetConstraints, this.getEditorController());
                this.subJob.addSubJob(removeValueJob);
                AddPropertyValueJob addValueJob = new AddPropertyValueJob(targetConstraints, (FXOMPropertyC)constraintsProperty, positionIndex, this.getEditorController());
                this.subJob.addSubJob(addValueJob);
                continue;
            }
            if (this.position != GridPaneJobUtils.Position.ABOVE || (aboveConstraints = mask.getRowConstraintsAtIndex(targetIndex - 1)) == null) continue;
            FXOMInstance addedConstraints = this.makeRowConstraintsInstance();
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(addedConstraints, (FXOMPropertyC)constraintsProperty, positionIndex, this.getEditorController());
            this.subJob.addSubJob(addValueJob);
        }
    }

    private void moveRowContent() {
        assert (this.subJob != null);
        block4: for (int targetIndex : this.targetIndexes) {
            switch (this.position) {
                case ABOVE: {
                    this.subJob.addSubJob(new ReIndexRowContentJob(this.getEditorController(), -1, this.targetGridPane, targetIndex));
                    int aboveIndex = targetIndex - 1;
                    if (this.targetIndexes.contains(aboveIndex)) continue block4;
                    int shiftIndex = 1;
                    while (this.targetIndexes.contains(targetIndex + shiftIndex)) {
                        ++shiftIndex;
                    }
                    this.subJob.addSubJob(new ReIndexRowContentJob(this.getEditorController(), shiftIndex, this.targetGridPane, aboveIndex));
                    continue block4;
                }
                case BELOW: {
                    this.subJob.addSubJob(new ReIndexRowContentJob(this.getEditorController(), 1, this.targetGridPane, targetIndex));
                    int belowIndex = targetIndex + 1;
                    if (this.targetIndexes.contains(belowIndex)) continue block4;
                    int shiftIndex = -1;
                    while (this.targetIndexes.contains(targetIndex + shiftIndex)) {
                        --shiftIndex;
                    }
                    this.subJob.addSubJob(new ReIndexRowContentJob(this.getEditorController(), shiftIndex, this.targetGridPane, belowIndex));
                    continue block4;
                }
            }
            assert (false);
            return;
        }
    }

    private FXOMInstance makeRowConstraintsInstance() {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, RowConstraints.class);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }

    private void updateSelection() {
        Selection selection = this.getEditorController().getSelection();
        assert (selection.isEmpty());
        for (int targetIndex : this.targetIndexes) {
            int positionIndex = this.position == GridPaneJobUtils.Position.ABOVE ? targetIndex - 1 : targetIndex + 1;
            selection.toggleSelection((FXOMInstance)this.targetGridPane, GridSelectionGroup.Type.ROW, positionIndex);
        }
    }
}

