/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.GridPane;

public class ReIndexRowContentJob
extends Job {
    private BatchJob subJob;
    private final int offset;
    private final FXOMObject targetGridPane;
    private final List<Integer> targetIndexes;

    public ReIndexRowContentJob(EditorController editorController, int offset, FXOMObject targetGridPane, List<Integer> targetIndexes) {
        super(editorController);
        this.offset = offset;
        this.targetGridPane = targetGridPane;
        this.targetIndexes = targetIndexes;
        this.buildSubJobs();
    }

    public ReIndexRowContentJob(EditorController editorController, int offset, FXOMObject targetGridPane, int targetIndex) {
        super(editorController);
        this.offset = offset;
        this.targetGridPane = targetGridPane;
        this.targetIndexes = new ArrayList<Integer>();
        this.targetIndexes.add(targetIndex);
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null;
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        assert (this.isExecutable());
        fxomDocument.beginUpdate();
        this.subJob.execute();
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.undo();
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        return "ReIndex Row Content";
    }

    private void buildSubJobs() {
        this.subJob = new BatchJob(this.getEditorController(), true, null);
        assert (!this.targetIndexes.isEmpty());
        DesignHierarchyMask targetGridPaneMask = new DesignHierarchyMask(this.targetGridPane);
        PropertyName propertyName = new PropertyName("rowIndex", GridPane.class);
        for (int targetIndex : this.targetIndexes) {
            List<FXOMObject> children = targetGridPaneMask.getRowContentAtIndex(targetIndex);
            for (FXOMObject child : children) {
                assert (child instanceof FXOMInstance);
                FXOMInstance childInstance = (FXOMInstance)child;
                ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(childInstance, propertyName);
                int newIndexValue = targetIndex + this.offset;
                ModifyObjectJob modifyJob = new ModifyObjectJob(childInstance, vpm, newIndexValue, this.getEditorController());
                this.subJob.addSubJob(modifyJob);
            }
        }
    }
}

