/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import java.util.List;

public class RemoveColumnConstraintsJob
extends Job {
    private BatchJob subJob;
    private final FXOMObject targetGridPane;
    private final List<Integer> targetIndexes;

    public RemoveColumnConstraintsJob(EditorController editorController, FXOMObject targetGridPane, List<Integer> targetIndexes) {
        super(editorController);
        assert (targetGridPane != null);
        assert (targetIndexes != null);
        this.targetGridPane = targetGridPane;
        this.targetIndexes = targetIndexes;
        this.buildSubJobs();
    }

    @Override
    public boolean isExecutable() {
        return this.subJob != null;
    }

    @Override
    public void execute() {
        assert (this.isExecutable());
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.execute();
        fxomDocument.endUpdate();
    }

    @Override
    public void undo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.undo();
        fxomDocument.endUpdate();
    }

    @Override
    public void redo() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        fxomDocument.beginUpdate();
        this.subJob.redo();
        fxomDocument.endUpdate();
    }

    @Override
    public String getDescription() {
        return "Remove Column Constraints";
    }

    private void buildSubJobs() {
        this.subJob = new BatchJob(this.getEditorController(), true, null);
        assert (this.targetGridPane instanceof FXOMInstance);
        assert (!this.targetIndexes.isEmpty());
        DesignHierarchyMask mask = new DesignHierarchyMask(this.targetGridPane);
        for (int targetIndex : this.targetIndexes) {
            FXOMObject targetConstraints = mask.getColumnConstraintsAtIndex(targetIndex);
            if (targetConstraints == null) continue;
            DeleteObjectJob removeValueJob = new DeleteObjectJob(targetConstraints, this.getEditorController());
            this.subJob.addSubJob(removeValueJob);
        }
    }
}

