/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.InsertColumnConstraintsJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.MoveColumnContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.list.ColumnConstraintsListPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.layout.GridPane;

public class InsertColumnJob
extends CompositeJob {
    private static final ColumnConstraintsListPropertyMetadata columnContraintsMeta = new ColumnConstraintsListPropertyMetadata(new PropertyName("columnConstraints"), true, Collections.emptyList(), InspectorPath.UNUSED);
    private final FXOMInstance gridPaneObject;
    private final int columnIndex;
    private final int insertCount;

    public InsertColumnJob(FXOMObject gridPaneObject, int columnIndex, int insertCount, EditorController editorController) {
        super(editorController);
        assert (gridPaneObject instanceof FXOMInstance);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        assert (columnIndex >= 0);
        assert (columnIndex <= columnContraintsMeta.getValue((FXOMInstance)gridPaneObject).size());
        assert (insertCount >= 1);
        this.gridPaneObject = (FXOMInstance)gridPaneObject;
        this.columnIndex = columnIndex;
        this.insertCount = insertCount;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        InsertColumnConstraintsJob insertJob = new InsertColumnConstraintsJob(this.gridPaneObject, this.columnIndex, this.insertCount, this.getEditorController());
        result.add(insertJob);
        MoveColumnContentJob moveJob = new MoveColumnContentJob(this.gridPaneObject, this.columnIndex, this.insertCount, this.getEditorController());
        if (((Job)moveJob).isExecutable()) {
            result.add(moveJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }
}

