/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2.MoveCellContentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.IntegerPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.InspectorPath;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.GridPane;

public class MoveColumnContentJob
extends CompositeJob {
    private final IntegerPropertyMetadata columnIndexMeta = new IntegerPropertyMetadata(new PropertyName("columnIndex", GridPane.class), true, 0, InspectorPath.UNUSED);
    private final FXOMInstance gridPaneObject;
    private final int movingColumnIndex;
    private final int columnIndexDelta;

    public MoveColumnContentJob(FXOMObject gridPaneObject, int movingColumnIndex, int columnIndexDelta, EditorController editorController) {
        super(editorController);
        assert (gridPaneObject instanceof FXOMInstance);
        assert (gridPaneObject.getSceneGraphObject() instanceof GridPane);
        assert (movingColumnIndex >= 0);
        this.gridPaneObject = (FXOMInstance)gridPaneObject;
        this.movingColumnIndex = movingColumnIndex;
        this.columnIndexDelta = columnIndexDelta;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        DesignHierarchyMask m = new DesignHierarchyMask(this.gridPaneObject);
        assert (m.isAcceptingSubComponent());
        int count = m.getSubComponentCount();
        for (int i = 0; i < count; ++i) {
            assert (m.getSubComponentAtIndex(i) instanceof FXOMInstance);
            FXOMInstance child = (FXOMInstance)m.getSubComponentAtIndex(i);
            if ((Integer)this.columnIndexMeta.getValue(child) != this.movingColumnIndex) continue;
            MoveCellContentJob subJob = new MoveCellContentJob(child, this.columnIndexDelta, 0, this.getEditorController());
            result.add(subJob);
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }
}

