/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.gridpane.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.layout.GridPane;

public class SpanJob
extends CompositeJob {
    private final EditorController.EditAction editAction;

    public SpanJob(EditorController editorController, EditorController.EditAction editAction) {
        super(editorController, true, true);
        this.editAction = editAction;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> jobList = new ArrayList<Job>();
        AbstractSelectionGroup selectionGroup = this.getEditorController().getSelection().getGroup();
        if (selectionGroup != null && selectionGroup instanceof ObjectSelectionGroup && selectionGroup.getAncestor() != null && selectionGroup.getAncestor().getSceneGraphObject() instanceof GridPane) {
            DesignHierarchyMask gridDHM = new DesignHierarchyMask(selectionGroup.getAncestor());
            int columnCount = gridDHM.getColumnsSize();
            int rowCount = gridDHM.getRowsSize();
            List<FXOMObject> items = ((ObjectSelectionGroup)selectionGroup).getSortedItems();
            for (FXOMObject fxomObject : items) {
                if (!(fxomObject instanceof FXOMInstance)) continue;
                Job job = this.createJob((FXOMInstance)fxomObject, columnCount, rowCount);
                if (job.isExecutable()) {
                    jobList.add(job);
                    continue;
                }
                jobList.clear();
                break;
            }
        }
        return jobList;
    }

    @Override
    protected String makeDescription() {
        String description = "";
        switch (this.editAction) {
            default: {
                description = I18N.getString("job.decrease.column.span");
                break;
            }
            case INCREASE_COLUMN_SPAN: {
                description = I18N.getString("job.increase.column.span");
                break;
            }
            case DECREASE_ROW_SPAN: {
                description = I18N.getString("job.decrease.row.span");
                break;
            }
            case INCREASE_ROW_SPAN: {
                description = I18N.getString("job.increase.row.span");
            }
        }
        assert (!description.isEmpty());
        return description;
    }

    private Job createJob(FXOMInstance candidate, int columnCount, int rowCount) {
        PropertyName propName = null;
        int newSpan = 1;
        switch (this.editAction) {
            default: {
                newSpan = this.getNewSpan(TREND.DECREASE, this.getValue(PROPERTY.COLUMN_INDEX, candidate), this.getValue(PROPERTY.COLUMN_SPAN, candidate), columnCount);
                propName = new PropertyName(this.getName(PROPERTY.COLUMN_SPAN), GridPane.class);
                break;
            }
            case INCREASE_COLUMN_SPAN: {
                newSpan = this.getNewSpan(TREND.INCREASE, this.getValue(PROPERTY.COLUMN_INDEX, candidate), this.getValue(PROPERTY.COLUMN_SPAN, candidate), columnCount);
                propName = new PropertyName(this.getName(PROPERTY.COLUMN_SPAN), GridPane.class);
                break;
            }
            case DECREASE_ROW_SPAN: {
                newSpan = this.getNewSpan(TREND.DECREASE, this.getValue(PROPERTY.ROW_INDEX, candidate), this.getValue(PROPERTY.ROW_SPAN, candidate), rowCount);
                propName = new PropertyName(this.getName(PROPERTY.ROW_SPAN), GridPane.class);
                break;
            }
            case INCREASE_ROW_SPAN: {
                newSpan = this.getNewSpan(TREND.INCREASE, this.getValue(PROPERTY.ROW_INDEX, candidate), this.getValue(PROPERTY.ROW_SPAN, candidate), rowCount);
                propName = new PropertyName(this.getName(PROPERTY.ROW_SPAN), GridPane.class);
            }
        }
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(candidate, propName);
        ModifyObjectJob columnSpanJob = new ModifyObjectJob(candidate, vpm, newSpan, this.getEditorController());
        return columnSpanJob;
    }

    private int getNewSpan(TREND trend, int index, int span, int count) {
        int newSpan = span;
        switch (trend) {
            case DECREASE: {
                if (span <= 1) break;
                newSpan = span - 1;
                break;
            }
            case INCREASE: {
                if (index + 1 >= count || span >= count) break;
                newSpan = span + 1;
            }
        }
        return newSpan;
    }

    private int getValue(PROPERTY property, FXOMInstance candidate) {
        String propertyName = this.getName(property);
        PropertyName propName = new PropertyName(propertyName, GridPane.class);
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(candidate, propName);
        Object value = vpm.getValueObject(candidate);
        if (value == null && (property == PROPERTY.COLUMN_SPAN || property == PROPERTY.ROW_SPAN)) {
            value = 1;
        }
        assert (value instanceof Integer);
        return (Integer)value;
    }

    private String getName(PROPERTY property) {
        String propertyName = "";
        switch (property) {
            case COLUMN_INDEX: {
                propertyName = "columnIndex";
                break;
            }
            case COLUMN_SPAN: {
                propertyName = "columnSpan";
                break;
            }
            case ROW_INDEX: {
                propertyName = "rowIndex";
                break;
            }
            case ROW_SPAN: {
                propertyName = "rowSpan";
            }
        }
        assert (!propertyName.isEmpty());
        return propertyName;
    }

    private static enum PROPERTY {
        COLUMN_INDEX,
        COLUMN_SPAN,
        ROW_INDEX,
        ROW_SPAN;

    }

    private static enum TREND {
        DECREASE,
        INCREASE;

    }
}

