/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMFxIdIndex;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AdjustAllToggleGroupJob
extends CompositeJob {
    public AdjustAllToggleGroupJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> makeSubJobs() {
        HashSet<String> toggleGroupIds = new HashSet<String>();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        FXOMFxIdIndex fxomIndex = new FXOMFxIdIndex(fxomDocument);
        for (FXOMInstance fXOMInstance : fxomIndex.collectToggleGroups()) {
            String toggleGroupId = fXOMInstance.getFxId();
            if (toggleGroupId == null) continue;
            toggleGroupIds.add(toggleGroupId);
        }
        PropertyName toggleGroupName = new PropertyName("toggleGroup");
        if (fxomDocument.getFxomRoot() != null) {
            for (FXOMProperty p : fxomDocument.getFxomRoot().collectProperties(toggleGroupName)) {
                FXOMPropertyT pt;
                PrefixedValue pv;
                if (!(p instanceof FXOMPropertyT) || !(pv = new PrefixedValue((pt = (FXOMPropertyT)p).getValue())).isExpression()) continue;
                toggleGroupIds.add(pv.getSuffix());
            }
        }
        ArrayList<Job> arrayList = new ArrayList<Job>();
        for (String toggleGroupId : toggleGroupIds) {
            AdjustToggleGroupJob adjustJob = new AdjustToggleGroupJob(toggleGroupId, this.getEditorController());
            assert (((Job)adjustJob).isExecutable());
            arrayList.add(adjustJob);
        }
        return arrayList;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }
}

