/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.List;
import javafx.scene.control.ToggleGroup;

public class AdjustToggleGroupJob
extends Job {
    private static final PropertyName toggleGroupName = new PropertyName("toggleGroup");
    private final String toggleGroupId;
    private final BatchJob batchJob;

    public AdjustToggleGroupJob(String toggleGroupId, EditorController editorController) {
        super(editorController);
        assert (toggleGroupId != null);
        this.toggleGroupId = toggleGroupId;
        this.batchJob = new BatchJob(this.getEditorController());
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        FXOMObject fxomRoot = fxomDocument.getFxomRoot();
        FXOMObject toggleGroupInstance = fxomRoot.searchWithFxId(this.toggleGroupId);
        List<FXOMPropertyT> references = FXOMNodes.collectToggleGroupReferences(fxomRoot, this.toggleGroupId);
        if (references.size() >= 1) {
            FXOMPropertyT firstReference = references.get(0);
            FXOMInstance firstReferencer = firstReference.getParentInstance();
            if (toggleGroupInstance == null) {
                FXOMInstance newToggleGroupInstance = new FXOMInstance(fxomDocument, ToggleGroup.class);
                newToggleGroupInstance.setFxId(this.toggleGroupId);
                FXOMPropertyC declarationProperty = new FXOMPropertyC(fxomDocument, toggleGroupName, newToggleGroupInstance);
                RemovePropertyJob removeFirstReferenceJob = new RemovePropertyJob(firstReference, this.getEditorController());
                AddPropertyJob addDeclarationJob = new AddPropertyJob(declarationProperty, firstReference.getParentInstance(), -1, this.getEditorController());
                this.batchJob.addSubJob(removeFirstReferenceJob);
                this.batchJob.addSubJob(addDeclarationJob);
            } else {
                FXOMPropertyC declaration = toggleGroupInstance.getParentProperty();
                FXOMInstance declarer = declaration.getParentInstance();
                List<FXOMObject> objectSequence = FXOMNodes.serializeObjects(fxomRoot);
                int firstReferencerIndex = objectSequence.indexOf(firstReferencer);
                int declarerIndex = objectSequence.indexOf(declarer);
                assert (firstReferencerIndex != -1);
                assert (declarerIndex != -1);
                if (firstReferencerIndex < declarerIndex) {
                    RemovePropertyJob removeFirstReferenceJob = new RemovePropertyJob(firstReference, this.getEditorController());
                    RemovePropertyJob removeDeclarationJob = new RemovePropertyJob(declaration, this.getEditorController());
                    AddPropertyJob addDeclarationJob = new AddPropertyJob(declaration, firstReference.getParentInstance(), 0, this.getEditorController());
                    AddPropertyJob addReferenceJob = new AddPropertyJob(firstReference, declarer, -1, this.getEditorController());
                    this.batchJob.addSubJob(removeFirstReferenceJob);
                    this.batchJob.addSubJob(removeDeclarationJob);
                    this.batchJob.addSubJob(addDeclarationJob);
                    this.batchJob.addSubJob(addReferenceJob);
                }
            }
        }
        if (this.batchJob.isExecutable()) {
            this.batchJob.execute();
        }
    }

    @Override
    public void undo() {
        if (this.batchJob.isExecutable()) {
            this.batchJob.undo();
        }
    }

    @Override
    public void redo() {
        if (this.batchJob.isExecutable()) {
            this.batchJob.redo();
        }
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

