/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.AdjustAllToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup.ModifyToggleGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.ClearSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.UpdateSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ToggleGroup;

public class ModifySelectionToggleGroupJob
extends CompositeJob {
    private final String toggleGroupId;

    public ModifySelectionToggleGroupJob(String toggleGroupId, EditorController editorController) {
        super(editorController);
        assert (editorController.getFxomDocument() != null);
        this.toggleGroupId = toggleGroupId;
    }

    @Override
    protected List<Job> makeSubJobs() {
        Selection selection;
        FXOMInstance toggleGroupInstance;
        FXOMDocument fxomDocument;
        FXOMObject toggleGroupObject;
        ArrayList<Job> result = new ArrayList<Job>();
        boolean executable = this.toggleGroupId == null ? true : ((toggleGroupObject = (fxomDocument = this.getEditorController().getFxomDocument()).searchWithFxId(this.toggleGroupId)) == null ? true : (toggleGroupObject instanceof FXOMInstance ? (toggleGroupInstance = (FXOMInstance)toggleGroupObject).getDeclaredClass() == ToggleGroup.class : false));
        if (executable && (selection = this.getEditorController().getSelection()).getGroup() instanceof ObjectSelectionGroup) {
            ObjectSelectionGroup osg = (ObjectSelectionGroup)selection.getGroup();
            for (FXOMObject fxomObject : osg.getItems()) {
                ModifyToggleGroupJob subJob = new ModifyToggleGroupJob(fxomObject, this.toggleGroupId, this.getEditorController());
                if (!((Job)subJob).isExecutable()) continue;
                result.add(subJob);
            }
            if (!result.isEmpty()) {
                result.add(0, new ClearSelectionJob(this.getEditorController()));
                result.add(new AdjustAllToggleGroupJob(this.getEditorController()));
                result.add(new UpdateSelectionJob(osg.getItems(), this.getEditorController()));
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return I18N.getString("job.set.toggle.group");
    }
}

