/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.togglegroup;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.CompositeJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.ToggleGroupPropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.util.ArrayList;
import java.util.List;

public class ModifyToggleGroupJob
extends CompositeJob {
    private static final PropertyName toggleGroupName = new PropertyName("toggleGroup");
    private final FXOMObject targetObject;
    private final String toggleGroupId;

    public ModifyToggleGroupJob(FXOMObject fxomObject, String toggleGroupId, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        assert (toggleGroupId == null || JavaLanguage.isIdentifier(toggleGroupId));
        this.targetObject = fxomObject;
        this.toggleGroupId = toggleGroupId;
    }

    @Override
    protected List<Job> makeSubJobs() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.targetObject instanceof FXOMInstance) {
            FXOMInstance targetInstance = (FXOMInstance)this.targetObject;
            ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(targetInstance, toggleGroupName);
            if (vpm instanceof ToggleGroupPropertyMetadata) {
                FXOMDocument fxomDocument = targetInstance.getFxomDocument();
                FXOMProperty fxomProperty = targetInstance.getProperties().get(toggleGroupName);
                if (fxomProperty != null) {
                    RemovePropertyJob removePropertyJob = new RemovePropertyJob(fxomProperty, this.getEditorController());
                    result.add(removePropertyJob);
                }
                if (this.toggleGroupId != null) {
                    PrefixedValue pv = new PrefixedValue(PrefixedValue.Type.EXPRESSION, this.toggleGroupId);
                    FXOMPropertyT newProperty = new FXOMPropertyT(fxomDocument, toggleGroupName, pv.toString());
                    AddPropertyJob addPropertyJob = new AddPropertyJob(newProperty, targetInstance, -1, this.getEditorController());
                    result.add(addPropertyJob);
                }
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        return this.getClass().getSimpleName();
    }
}

