/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;

public class AddPropertyJob
extends Job {
    private final FXOMProperty property;
    private final FXOMInstance targetInstance;
    private final int targetIndex;

    public AddPropertyJob(FXOMProperty property, FXOMInstance targetInstance, int targetIndex, EditorController editorController) {
        super(editorController);
        assert (property != null);
        assert (targetInstance != null);
        assert (targetIndex >= -1);
        this.property = property;
        this.targetInstance = targetInstance;
        this.targetIndex = targetIndex;
    }

    @Override
    public boolean isExecutable() {
        return this.property.getParentInstance() == null;
    }

    @Override
    public void execute() {
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.property.getParentInstance() == this.targetInstance);
        this.getEditorController().getSelection().clear();
        this.getEditorController().getFxomDocument().beginUpdate();
        this.property.removeFromParentInstance();
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.property.getParentInstance() == null);
    }

    @Override
    public void redo() {
        assert (this.property.getParentInstance() == null);
        this.getEditorController().getFxomDocument().beginUpdate();
        this.property.addToParentInstance(this.targetIndex, this.targetInstance);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.property.getParentInstance() == this.targetInstance);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

