/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;

public class AddPropertyValueJob
extends Job {
    private final FXOMObject value;
    private final FXOMPropertyC targetProperty;
    private final int targetIndex;

    public AddPropertyValueJob(FXOMObject value, FXOMPropertyC targetProperty, int targetIndex, EditorController editorController) {
        super(editorController);
        assert (value != null);
        assert (targetProperty != null);
        assert (targetIndex >= -1);
        this.value = value;
        this.targetProperty = targetProperty;
        this.targetIndex = targetIndex;
    }

    @Override
    public boolean isExecutable() {
        return this.value.getParentProperty() == null && this.value.getParentCollection() == null;
    }

    @Override
    public void execute() {
        assert (this.targetIndex <= this.targetProperty.getValues().size());
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.value.getParentProperty() == this.targetProperty);
        assert (this.value.getParentCollection() == null);
        this.getEditorController().getSelection().clear();
        this.getEditorController().getFxomDocument().beginUpdate();
        this.value.removeFromParentProperty();
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.value.getParentProperty() == null);
        assert (this.value.getParentCollection() == null);
    }

    @Override
    public void redo() {
        assert (this.value.getParentProperty() == null);
        assert (this.value.getParentCollection() == null);
        this.getEditorController().getFxomDocument().beginUpdate();
        this.value.addToParentProperty(this.targetIndex, this.targetProperty);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.value.getParentProperty() == this.targetProperty);
        assert (this.value.getParentCollection() == null);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

