/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import java.util.Collections;
import java.util.List;

public abstract class CompositeJob
extends Job {
    private final boolean shouldRefreshSceneGraph;
    private final boolean shouldUpdateSelection;
    private List<Job> subJobs;
    private String description;

    public CompositeJob(EditorController editorController) {
        this(editorController, true, true);
    }

    public CompositeJob(EditorController editorController, boolean shouldRefreshSceneGraph, boolean shouldUpdateSelection) {
        super(editorController);
        this.shouldRefreshSceneGraph = shouldRefreshSceneGraph;
        this.shouldUpdateSelection = shouldUpdateSelection;
    }

    public List<Job> getSubJobs() {
        if (this.subJobs == null) {
            this.subJobs = this.makeSubJobs();
            assert (this.subJobs != null);
            this.subJobs = Collections.unmodifiableList(this.subJobs);
        }
        return this.subJobs;
    }

    protected abstract List<Job> makeSubJobs();

    protected abstract String makeDescription();

    @Override
    public boolean isExecutable() {
        return !this.getSubJobs().isEmpty();
    }

    @Override
    public void execute() {
        Selection selection = this.getEditorController().getSelection();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (this.shouldUpdateSelection) {
            selection.beginUpdate();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.beginUpdate();
        }
        for (Job subJob : this.getSubJobs()) {
            subJob.execute();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.endUpdate();
        }
        if (this.shouldUpdateSelection) {
            selection.endUpdate();
        }
    }

    @Override
    public void undo() {
        Selection selection = this.getEditorController().getSelection();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (this.shouldUpdateSelection) {
            selection.beginUpdate();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.beginUpdate();
        }
        for (int i = this.getSubJobs().size() - 1; i >= 0; --i) {
            this.getSubJobs().get(i).undo();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.endUpdate();
        }
        if (this.shouldUpdateSelection) {
            selection.endUpdate();
        }
    }

    @Override
    public void redo() {
        Selection selection = this.getEditorController().getSelection();
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        if (this.shouldUpdateSelection) {
            selection.beginUpdate();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.beginUpdate();
        }
        for (Job subJob : this.getSubJobs()) {
            subJob.redo();
        }
        if (this.shouldRefreshSceneGraph) {
            fxomDocument.endUpdate();
        }
        if (this.shouldUpdateSelection) {
            selection.endUpdate();
        }
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.makeDescription();
            assert (this.description != null);
        }
        return this.description;
    }
}

