/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;

public class RemoveFxControllerJob
extends Job {
    private final FXOMObject fxomObject;
    private String oldFxController;

    public RemoveFxControllerJob(FXOMObject fxomObject, EditorController editorController) {
        super(editorController);
        assert (fxomObject != null);
        this.fxomObject = fxomObject;
    }

    @Override
    public boolean isExecutable() {
        return this.fxomObject.getFxController() != null;
    }

    @Override
    public void execute() {
        assert (this.oldFxController == null);
        this.oldFxController = this.fxomObject.getFxController();
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.oldFxController != null);
        this.fxomObject.setFxController(this.oldFxController);
    }

    @Override
    public void redo() {
        assert (this.oldFxController != null);
        this.fxomObject.setFxController(null);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }
}

