/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;

public class RemovePropertyJob
extends Job {
    private final FXOMProperty targetProperty;
    private FXOMInstance parentInstance;
    private int indexInParentInstance;

    public RemovePropertyJob(FXOMProperty targetProperty, EditorController editorController) {
        super(editorController);
        assert (targetProperty != null);
        this.targetProperty = targetProperty;
    }

    @Override
    public boolean isExecutable() {
        return this.targetProperty.getParentInstance() != null;
    }

    @Override
    public void execute() {
        assert (this.parentInstance == null);
        this.parentInstance = this.targetProperty.getParentInstance();
        this.indexInParentInstance = this.targetProperty.getIndexInParentInstance();
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.targetProperty.getParentInstance() == null);
        this.getEditorController().getFxomDocument().beginUpdate();
        this.targetProperty.addToParentInstance(this.indexInParentInstance, this.parentInstance);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetProperty.getParentInstance() == this.parentInstance);
        assert (this.targetProperty.getIndexInParentInstance() == this.indexInParentInstance);
    }

    @Override
    public void redo() {
        assert (this.targetProperty.getParentInstance() == this.parentInstance);
        assert (this.targetProperty.getIndexInParentInstance() == this.indexInParentInstance);
        this.getEditorController().getSelection().clear();
        this.getEditorController().getFxomDocument().beginUpdate();
        this.targetProperty.removeFromParentInstance();
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetProperty.getParentInstance() == null);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "[" + this.targetProperty.getName() + "]";
    }
}

