/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.v2;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;

public class RemovePropertyValueJob
extends Job {
    private final FXOMObject targetValue;
    private FXOMPropertyC parentProperty;
    private int indexInParentProperty;

    public RemovePropertyValueJob(FXOMObject value, EditorController editorController) {
        super(editorController);
        this.targetValue = value;
    }

    @Override
    public boolean isExecutable() {
        FXOMPropertyC p = this.targetValue.getParentProperty();
        return p != null && p.getValues().size() >= 2;
    }

    @Override
    public void execute() {
        assert (this.parentProperty == null);
        this.parentProperty = this.targetValue.getParentProperty();
        this.indexInParentProperty = this.targetValue.getIndexInParentProperty();
        this.redo();
    }

    @Override
    public void undo() {
        assert (this.targetValue.getParentProperty() == null);
        this.getEditorController().getFxomDocument().beginUpdate();
        this.targetValue.addToParentProperty(this.indexInParentProperty, this.parentProperty);
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetValue.getParentProperty() == this.parentProperty);
        assert (this.targetValue.getIndexInParentProperty() == this.indexInParentProperty);
    }

    @Override
    public void redo() {
        assert (this.targetValue.getParentProperty() == this.parentProperty);
        assert (this.targetValue.getIndexInParentProperty() == this.indexInParentProperty);
        this.getEditorController().getSelection().clear();
        this.getEditorController().getFxomDocument().beginUpdate();
        this.targetValue.removeFromParentProperty();
        this.getEditorController().getFxomDocument().endUpdate();
        assert (this.targetValue.getParentProperty() == null);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "[" + this.targetValue.getGlueElement().getTagName() + "]";
    }
}

