/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javafx.scene.layout.AnchorPane;

public abstract class AbstractWrapInContentJob
extends AbstractWrapInJob {
    public AbstractWrapInContentJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    protected List<Job> wrapInJobs(Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        assert (newContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
        PropertyName newContainerPropertyName = new PropertyName("content");
        FXOMPropertyC newContainerProperty = new FXOMPropertyC(this.newContainer.getFxomDocument(), newContainerPropertyName);
        if (children.size() > 1) {
            FXOMInstance subContainer = this.makeContainerInstance(AnchorPane.class);
            DesignHierarchyMask subContainerMask = new DesignHierarchyMask(subContainer);
            PropertyName subContainerPropertyName = subContainerMask.getSubComponentPropertyName();
            FXOMPropertyC subContainerProperty = new FXOMPropertyC(subContainer.getFxomDocument(), subContainerPropertyName);
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(subContainer, newContainerProperty, -1, this.getEditorController());
            jobs.add(addValueJob);
            assert (subContainerMask.isFreeChildPositioning());
            List<Job> modifyChildrenLayoutJobs = this.modifyChildrenLayoutJobs(children);
            jobs.addAll(modifyChildrenLayoutJobs);
            List<Job> addChildrenJobs = this.addChildrenToPropertyJobs(subContainerProperty, children);
            jobs.addAll(addChildrenJobs);
            assert (subContainerProperty.getParentInstance() == null);
            AddPropertyJob addPropertyJob = new AddPropertyJob(subContainerProperty, subContainer, -1, this.getEditorController());
            jobs.add(addPropertyJob);
        } else {
            List<Job> modifyChildrenJobs = this.modifyChildrenJobs(children);
            jobs.addAll(modifyChildrenJobs);
            List<Job> addChildrenJobs = this.addChildrenToPropertyJobs(newContainerProperty, children);
            jobs.addAll(addChildrenJobs);
        }
        assert (newContainerProperty.getParentInstance() == null);
        AddPropertyJob addPropertyJob = new AddPropertyJob(newContainerProperty, this.newContainer, -1, this.getEditorController());
        jobs.add(addPropertyJob);
        return jobs;
    }
}

