/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.DeleteObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ToggleFxRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInAnchorPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInGridPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInGroupJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInHBoxJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInScrollPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInSplitPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInStackPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInTabPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInTitledPaneJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInToolBarJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapInVBoxJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public abstract class AbstractWrapInJob
extends Job {
    protected Class<?> newContainerClass;
    private BatchJob batchJob;
    private AbstractSelectionGroup selectionSnapshot;
    protected FXOMInstance oldContainer;
    protected FXOMInstance newContainer;

    public AbstractWrapInJob(EditorController editorController) {
        super(editorController);
    }

    public static AbstractWrapInJob getWrapInJob(EditorController editorController, Class<? extends Parent> wrappingClass) {
        AbstractWrapInJob job;
        assert (EditorController.getClassesSupportingWrapping().contains(wrappingClass));
        if (wrappingClass == AnchorPane.class) {
            job = new WrapInAnchorPaneJob(editorController);
        } else if (wrappingClass == GridPane.class) {
            job = new WrapInGridPaneJob(editorController);
        } else if (wrappingClass == Group.class) {
            job = new WrapInGroupJob(editorController);
        } else if (wrappingClass == HBox.class) {
            job = new WrapInHBoxJob(editorController);
        } else if (wrappingClass == Pane.class) {
            job = new WrapInPaneJob(editorController);
        } else if (wrappingClass == ScrollPane.class) {
            job = new WrapInScrollPaneJob(editorController);
        } else if (wrappingClass == SplitPane.class) {
            job = new WrapInSplitPaneJob(editorController);
        } else if (wrappingClass == StackPane.class) {
            job = new WrapInStackPaneJob(editorController);
        } else if (wrappingClass == TabPane.class) {
            job = new WrapInTabPaneJob(editorController);
        } else if (wrappingClass == TitledPane.class) {
            job = new WrapInTitledPaneJob(editorController);
        } else if (wrappingClass == ToolBar.class) {
            job = new WrapInToolBarJob(editorController);
        } else {
            assert (wrappingClass == VBox.class);
            job = new WrapInVBoxJob(editorController);
        }
        return job;
    }

    @Override
    public boolean isExecutable() {
        return WrapJobUtils.canWrapIn(this.getEditorController());
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        assert (this.isExecutable());
        this.buildSubJobs();
        try {
            this.selectionSnapshot = selection.getGroup().clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.batchJob.execute();
        fxomDocument.endUpdate();
        selection.select(this.newContainer);
        selection.endUpdate();
    }

    @Override
    public void undo() {
        assert (this.batchJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.batchJob.undo();
        fxomDocument.endUpdate();
        selection.select(this.selectionSnapshot);
        selection.endUpdate();
    }

    @Override
    public void redo() {
        assert (this.batchJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.batchJob.redo();
        fxomDocument.endUpdate();
        selection.select(this.newContainer);
        selection.endUpdate();
    }

    @Override
    public String getDescription() {
        return "Wrap in " + this.newContainerClass.getSimpleName();
    }

    protected void buildSubJobs() {
        assert (this.isExecutable());
        this.batchJob = new BatchJob(this.getEditorController());
        Selection selection = this.getEditorController().getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        assert (asg instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        this.oldContainer = (FXOMInstance)osg.getAncestor();
        Set<FXOMObject> children = osg.getItems();
        this.newContainer = this.makeContainerInstance();
        if (this.oldContainer != null) {
            PropertyName oldContainerPropertyName = WrapJobUtils.getContainerPropertyName(this.oldContainer, children);
            FXOMPropertyC oldContainerProperty = (FXOMPropertyC)this.oldContainer.getProperties().get(oldContainerPropertyName);
            assert (oldContainerProperty != null && oldContainerProperty.getParentInstance() != null);
            DesignHierarchyMask oldContainerMask = new DesignHierarchyMask(this.oldContainer);
            if (oldContainerMask.isFreeChildPositioning() && Region.class.isAssignableFrom(this.newContainer.getDeclaredClass())) {
                this.modifyContainerLayout(children);
            }
            this.modifyContainer(children);
            int newContainerIndex = this.getIndex(this.oldContainer, children);
            AddPropertyValueJob newContainerAddValueJob = new AddPropertyValueJob(this.newContainer, oldContainerProperty, newContainerIndex, this.getEditorController());
            this.batchJob.addSubJob(newContainerAddValueJob);
            List<Job> deleteChildrenJobs = this.deleteChildrenJobs(children);
            this.batchJob.addSubJobs(deleteChildrenJobs);
        } else {
            assert (children.size() == 1);
            FXOMObject rootObject = children.iterator().next();
            assert (rootObject instanceof FXOMInstance);
            boolean isFxRoot = ((FXOMInstance)rootObject).isFxRoot();
            String fxController = rootObject.getFxController();
            if (isFxRoot) {
                ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                this.batchJob.addSubJob(fxRootJob);
            }
            if (fxController != null) {
                ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(rootObject, null, this.getEditorController());
                this.batchJob.addSubJob(fxControllerJob);
            }
            SetDocumentRootJob setDocumentRoot = new SetDocumentRootJob(this.newContainer, this.getEditorController());
            this.batchJob.addSubJob(setDocumentRoot);
            if (isFxRoot) {
                ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                this.batchJob.addSubJob(fxRootJob);
            }
            if (fxController != null) {
                ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(this.newContainer, fxController, this.getEditorController());
                this.batchJob.addSubJob(fxControllerJob);
            }
        }
        this.batchJob.addSubJobs(this.wrapInJobs(children));
    }

    protected List<Job> addChildrenToPropertyJobs(FXOMPropertyC containerProperty, Collection<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        int index = 0;
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(child, containerProperty, index++, this.getEditorController());
            jobs.add(addValueJob);
        }
        return jobs;
    }

    protected List<Job> deleteChildrenJobs(Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            DeleteObjectJob deleteObjectJob = new DeleteObjectJob(child, this.getEditorController());
            jobs.add(deleteObjectJob);
        }
        return jobs;
    }

    protected abstract List<Job> wrapInJobs(Set<FXOMObject> var1);

    protected abstract List<Job> modifyChildrenJobs(Set<FXOMObject> var1);

    protected abstract void modifyContainer(Set<FXOMObject> var1);

    protected List<Job> modifyChildrenLayoutJobs(Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        Bounds unionOfBounds = WrapJobUtils.getUnionOfBounds(children);
        for (FXOMObject child : children) {
            assert (child.getSceneGraphObject() instanceof Node);
            Node childNode = (Node)child.getSceneGraphObject();
            Bounds childBounds = childNode.getLayoutBounds();
            Point2D point = childNode.localToParent(childBounds.getMinX(), childBounds.getMinY());
            double layoutX = point.getX() - unionOfBounds.getMinX();
            double layoutY = point.getY() - unionOfBounds.getMinY();
            ModifyObjectJob modifyLayoutX = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutX", layoutX, this.getEditorController());
            jobs.add(modifyLayoutX);
            ModifyObjectJob modifyLayoutY = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutY", layoutY, this.getEditorController());
            jobs.add(modifyLayoutY);
        }
        return jobs;
    }

    protected void modifyContainerLayout(Set<FXOMObject> children) {
        Bounds unionOfBounds = WrapJobUtils.getUnionOfBounds(children);
        JobUtils.setLayoutX(this.newContainer, Node.class, unionOfBounds.getMinX());
        JobUtils.setLayoutY(this.newContainer, Node.class, unionOfBounds.getMinY());
    }

    protected FXOMInstance makeContainerInstance(Class<?> containerClass) {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, containerClass);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }

    private FXOMInstance makeContainerInstance() {
        return this.makeContainerInstance(this.newContainerClass);
    }

    private int getIndex(FXOMInstance container, Set<FXOMObject> fxomObjects) {
        DesignHierarchyMask mask = new DesignHierarchyMask(container);
        if (!mask.isAcceptingSubComponent()) {
            return -1;
        }
        Iterator<FXOMObject> iterator = fxomObjects.iterator();
        assert (iterator.hasNext());
        int result = iterator.next().getIndexInParentProperty();
        while (iterator.hasNext()) {
            int index = iterator.next().getIndexInParentProperty();
            if (index >= result) continue;
            result = index;
        }
        return result;
    }
}

