/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyFxControllerJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.SetDocumentRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.ToggleFxRootJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.RemovePropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.RemovePropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapJobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;

public class UnwrapJob
extends Job {
    private BatchJob batchJob;
    private AbstractSelectionGroup selectionSnapshot;
    private FXOMInstance oldContainer;
    private FXOMInstance newContainer;
    private Set<FXOMObject> oldContainerChildren;

    public UnwrapJob(EditorController editorController) {
        super(editorController);
    }

    @Override
    public boolean isExecutable() {
        return WrapJobUtils.canUnwrap(this.getEditorController());
    }

    @Override
    public void execute() {
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        assert (this.isExecutable());
        this.buildSubJobs();
        try {
            this.selectionSnapshot = selection.getGroup().clone();
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException(x);
        }
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.batchJob.execute();
        fxomDocument.endUpdate();
        selection.select(this.oldContainerChildren);
        selection.endUpdate();
    }

    @Override
    public void undo() {
        assert (this.batchJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.batchJob.undo();
        fxomDocument.endUpdate();
        selection.select(this.selectionSnapshot);
        selection.endUpdate();
    }

    @Override
    public void redo() {
        assert (this.batchJob != null);
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        Selection selection = this.getEditorController().getSelection();
        selection.clear();
        selection.beginUpdate();
        fxomDocument.beginUpdate();
        this.batchJob.redo();
        fxomDocument.endUpdate();
        selection.select(this.oldContainerChildren);
        selection.endUpdate();
    }

    @Override
    public String getDescription() {
        return "Unwrap";
    }

    protected void buildSubJobs() {
        assert (this.isExecutable());
        this.batchJob = new BatchJob(this.getEditorController());
        Selection selection = this.getEditorController().getSelection();
        AbstractSelectionGroup asg = selection.getGroup();
        assert (asg instanceof ObjectSelectionGroup);
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        assert (osg.getItems().size() == 1);
        this.oldContainer = (FXOMInstance)osg.getItems().iterator().next();
        this.oldContainerChildren = this.getChildren(this.oldContainer);
        PropertyName oldContainerPropertyName = WrapJobUtils.getContainerPropertyName(this.oldContainer, this.oldContainerChildren);
        FXOMPropertyC oldContainerProperty = (FXOMPropertyC)this.oldContainer.getProperties().get(oldContainerPropertyName);
        assert (oldContainerProperty != null && oldContainerProperty.getParentInstance() != null);
        this.newContainer = (FXOMInstance)this.oldContainer.getParentObject();
        RemovePropertyJob removePropertyJob = new RemovePropertyJob(oldContainerProperty, this.getEditorController());
        this.batchJob.addSubJob(removePropertyJob);
        List<Job> removeChildrenJobs = this.removeChildrenFromPropertyJobs(oldContainerProperty, this.oldContainerChildren);
        this.batchJob.addSubJobs(removeChildrenJobs);
        if (this.newContainer != null) {
            HashSet<FXOMObject> newContainerChildren = new HashSet<FXOMObject>();
            newContainerChildren.add(this.oldContainer);
            PropertyName newContainerPropertyName = WrapJobUtils.getContainerPropertyName(this.newContainer, newContainerChildren);
            FXOMPropertyC newContainerProperty = (FXOMPropertyC)this.newContainer.getProperties().get(newContainerPropertyName);
            assert (newContainerProperty != null && newContainerProperty.getParentInstance() != null);
            DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
            if (newContainerMask.isFreeChildPositioning()) {
                List<Job> modifyChildrenLayoutJobs = this.modifyChildrenLayoutJobs(this.oldContainerChildren);
                this.batchJob.addSubJobs(modifyChildrenLayoutJobs);
            }
            int index = this.oldContainer.getIndexInParentProperty();
            List<Job> addChildrenJobs = this.addChildrenToPropertyJobs(newContainerProperty, index, this.oldContainerChildren);
            this.batchJob.addSubJobs(addChildrenJobs);
            RemovePropertyValueJob removeValueJob = new RemovePropertyValueJob(this.oldContainer, this.getEditorController());
            this.batchJob.addSubJob(removeValueJob);
        } else {
            assert (this.oldContainerChildren.size() == 1);
            boolean isFxRoot = this.oldContainer.isFxRoot();
            String fxController = this.oldContainer.getFxController();
            if (isFxRoot) {
                ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                this.batchJob.addSubJob(fxRootJob);
            }
            if (fxController != null) {
                ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(this.oldContainer, null, this.getEditorController());
                this.batchJob.addSubJob(fxControllerJob);
            }
            FXOMObject child = this.oldContainerChildren.iterator().next();
            SetDocumentRootJob setDocumentRoot = new SetDocumentRootJob(child, this.getEditorController());
            this.batchJob.addSubJob(setDocumentRoot);
            if (isFxRoot) {
                ToggleFxRootJob fxRootJob = new ToggleFxRootJob(this.getEditorController());
                this.batchJob.addSubJob(fxRootJob);
            }
            if (fxController != null) {
                ModifyFxControllerJob fxControllerJob = new ModifyFxControllerJob(child, fxController, this.getEditorController());
                this.batchJob.addSubJob(fxControllerJob);
            }
        }
    }

    protected List<Job> addChildrenToPropertyJobs(FXOMPropertyC containerProperty, int start, Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        int index = start;
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(child, containerProperty, index++, this.getEditorController());
            jobs.add(addValueJob);
        }
        return jobs;
    }

    protected List<Job> removeChildrenFromPropertyJobs(FXOMPropertyC containerProperty, Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (FXOMObject child : children) {
            assert (child instanceof FXOMInstance);
            RemovePropertyValueJob removeValueJob = new RemovePropertyValueJob(child, this.getEditorController());
            jobs.add(removeValueJob);
        }
        return jobs;
    }

    protected List<Job> modifyChildrenLayoutJobs(Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        assert (this.oldContainer.getSceneGraphObject() instanceof Node);
        Node oldContainerNode = (Node)this.oldContainer.getSceneGraphObject();
        Bounds oldContainerBounds = oldContainerNode.getLayoutBounds();
        Point2D point = oldContainerNode.localToParent(oldContainerBounds.getMinX(), oldContainerBounds.getMinY());
        for (FXOMObject child : children) {
            assert (child.getSceneGraphObject() instanceof Node);
            Node childNode = (Node)child.getSceneGraphObject();
            double layoutX = point.getX() + childNode.getLayoutX();
            double layoutY = point.getY() + childNode.getLayoutY();
            ModifyObjectJob modifyLayoutX = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutX", layoutX, this.getEditorController());
            jobs.add(modifyLayoutX);
            ModifyObjectJob modifyLayoutY = WrapJobUtils.modifyObjectJob((FXOMInstance)child, "layoutY", layoutY, this.getEditorController());
            jobs.add(modifyLayoutY);
        }
        return jobs;
    }

    private Set<FXOMObject> getChildren(FXOMObject container) {
        DesignHierarchyMask mask = new DesignHierarchyMask(container);
        HashSet<FXOMObject> result = new HashSet<FXOMObject>();
        if (mask.isAcceptingSubComponent()) {
            int count = mask.getSubComponentCount();
            for (int i = 0; i < count; ++i) {
                FXOMObject child = mask.getSubComponentAtIndex(i);
                result.add(child);
            }
        } else {
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
            FXOMObject child = mask.getAccessory(DesignHierarchyMask.Accessory.CONTENT);
            result.add(child);
        }
        return result;
    }
}

