/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.JobUtils;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInSubComponentJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.FXOMObjectCourseComparator;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.WrapJobUtils;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class WrapInGridPaneJob
extends AbstractWrapInSubComponentJob {
    private static final double DEFAULT_MIN_WIDTH = 10.0;
    private static final double DEFAULT_MIN_HEIGHT = 10.0;
    private final Map<FXOMObject, int[]> indices = new HashMap<FXOMObject, int[]>();

    public WrapInGridPaneJob(EditorController editorController) {
        super(editorController);
        this.newContainerClass = GridPane.class;
    }

    @Override
    protected List<Job> modifyChildrenJobs(Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (this.indices.isEmpty()) {
            this.modifyContainer(children);
        }
        for (FXOMObject child : children) {
            int[] childIndices = this.indices.get(child);
            ModifyObjectJob modifyColumnIndex = WrapJobUtils.modifyObjectJob((FXOMInstance)child, GridPane.class, "columnIndex", childIndices[FXOMObjectCourseComparator.GridCourse.COL_BY_COL.index()], this.getEditorController());
            jobs.add(modifyColumnIndex);
            ModifyObjectJob modifyRowIndex = WrapJobUtils.modifyObjectJob((FXOMInstance)child, GridPane.class, "rowIndex", childIndices[FXOMObjectCourseComparator.GridCourse.ROW_BY_ROW.index()], this.getEditorController());
            jobs.add(modifyRowIndex);
        }
        return jobs;
    }

    @Override
    protected void modifyContainer(Set<FXOMObject> children) {
        FXOMInstance constraint;
        int index;
        FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
        int maxcol = this.computeIndexByCourse(children, FXOMObjectCourseComparator.GridCourse.COL_BY_COL, this.indices);
        int maxrow = this.computeIndexByCourse(children, FXOMObjectCourseComparator.GridCourse.ROW_BY_ROW, this.indices);
        double[] columnWidth = new double[maxcol + 1];
        double[] rowHeight = new double[maxrow + 1];
        this.computeSizes(children, this.indices, columnWidth, rowHeight);
        for (index = 0; index <= maxcol; ++index) {
            constraint = this.makeConstraintsInstance(ColumnConstraints.class);
            JobUtils.setHGrow(constraint, ColumnConstraints.class, Priority.SOMETIMES.name());
            if (columnWidth[index] >= 10.0) {
                JobUtils.setMinWidth(constraint, ColumnConstraints.class, 10.0);
            } else {
                JobUtils.setMinWidth(constraint, ColumnConstraints.class, columnWidth[index]);
            }
            JobUtils.addColumnConstraints(fxomDocument, this.newContainer, constraint, index);
        }
        for (index = 0; index <= maxrow; ++index) {
            constraint = this.makeConstraintsInstance(RowConstraints.class);
            JobUtils.setVGrow(constraint, RowConstraints.class, Priority.SOMETIMES.name());
            if (rowHeight[index] >= 10.0) {
                JobUtils.setMinHeight(constraint, RowConstraints.class, 10.0);
            } else {
                JobUtils.setMinHeight(constraint, RowConstraints.class, rowHeight[index]);
            }
            JobUtils.addRowConstraints(fxomDocument, this.newContainer, constraint, index);
        }
    }

    private int computeIndexByCourse(Set<FXOMObject> fxomObjects, FXOMObjectCourseComparator.GridCourse course, Map<FXOMObject, int[]> indices) {
        FXOMObjectCourseComparator.BidimensionalComparator comparator = new FXOMObjectCourseComparator.BidimensionalComparator(course);
        ArrayList<FXOMObject> unsorted = new ArrayList<FXOMObject>(fxomObjects);
        Collections.sort(unsorted, comparator);
        FXOMObject lastObject = null;
        int rc = 0;
        int max = -1;
        for (int i = 0; i < unsorted.size(); ++i) {
            FXOMObject currentObject = (FXOMObject)unsorted.get(i);
            int[] ind = indices.get(currentObject);
            if (ind == null) {
                ind = new int[2];
                indices.put(currentObject, ind);
            }
            if (lastObject != null && comparator.compare(lastObject, currentObject) != 0) {
                Node lastNode = (Node)lastObject.getSceneGraphObject();
                Node currentNode = (Node)currentObject.getSceneGraphObject();
                Bounds lastBounds = lastNode.getBoundsInParent();
                Bounds currentBounds = currentNode.getBoundsInParent();
                if (course.getMinY(currentBounds) >= course.getMaxY(lastBounds) - 1.0) {
                    // empty if block
                }
            }
            ind[course.index()] = ++rc;
            max = Math.max(max, rc);
            lastObject = currentObject;
        }
        return max;
    }

    private void computeSizes(Set<FXOMObject> fxomObjects, Map<FXOMObject, int[]> indices, double[] columnWidth, double[] rowHeight) {
        for (FXOMObject fxomObject : fxomObjects) {
            Node node = (Node)fxomObject.getSceneGraphObject();
            double width = node.getBoundsInLocal().getWidth();
            double height = node.getBoundsInLocal().getHeight();
            int[] ind = indices.get(fxomObject);
            int col = ind[FXOMObjectCourseComparator.GridCourse.COL_BY_COL.index()];
            int row = ind[FXOMObjectCourseComparator.GridCourse.ROW_BY_ROW.index()];
            columnWidth[col] = Math.max(columnWidth[col], width);
            rowHeight[row] = Math.max(rowHeight[row], height);
        }
    }

    private FXOMInstance makeConstraintsInstance(Class<?> constraintsClass) {
        FXOMDocument newDocument = new FXOMDocument();
        FXOMInstance result = new FXOMInstance(newDocument, constraintsClass);
        newDocument.setFxomRoot(result);
        result.moveToFxomDocument(this.getEditorController().getFxomDocument());
        return result;
    }
}

