/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.v2.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.wrap.AbstractWrapInJob;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;

public class WrapInTabPaneJob
extends AbstractWrapInJob {
    public WrapInTabPaneJob(EditorController editorController) {
        super(editorController);
        this.newContainerClass = TabPane.class;
    }

    @Override
    protected List<Job> wrapInJobs(Set<FXOMObject> children) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        DesignHierarchyMask newContainerMask = new DesignHierarchyMask(this.newContainer);
        assert (newContainerMask.isAcceptingSubComponent());
        PropertyName newContainerPropertyName = newContainerMask.getSubComponentPropertyName();
        FXOMPropertyC newContainerProperty = new FXOMPropertyC(this.newContainer.getFxomDocument(), newContainerPropertyName);
        FXOMInstance tabContainer = this.makeContainerInstance(Tab.class);
        DesignHierarchyMask tabContainerMask = new DesignHierarchyMask(tabContainer);
        assert (tabContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
        PropertyName tabContainerPropertyName = new PropertyName("content");
        FXOMPropertyC tabContainerProperty = new FXOMPropertyC(tabContainer.getFxomDocument(), tabContainerPropertyName);
        AddPropertyValueJob addTabValueJob = new AddPropertyValueJob(tabContainer, newContainerProperty, -1, this.getEditorController());
        jobs.add(addTabValueJob);
        if (children.size() > 1) {
            FXOMInstance subContainer = this.makeContainerInstance(AnchorPane.class);
            DesignHierarchyMask subContainerMask = new DesignHierarchyMask(subContainer);
            PropertyName subContainerPropertyName = subContainerMask.getSubComponentPropertyName();
            FXOMPropertyC subContainerProperty = new FXOMPropertyC(subContainer.getFxomDocument(), subContainerPropertyName);
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(subContainer, tabContainerProperty, -1, this.getEditorController());
            jobs.add(addValueJob);
            assert (subContainerMask.isFreeChildPositioning());
            List<Job> modifyChildrenLayoutJobs = this.modifyChildrenLayoutJobs(children);
            jobs.addAll(modifyChildrenLayoutJobs);
            List<Job> addChildrenJobs = this.addChildrenToPropertyJobs(subContainerProperty, children);
            jobs.addAll(addChildrenJobs);
            assert (subContainerProperty.getParentInstance() == null);
            AddPropertyJob addPropertyJob = new AddPropertyJob(subContainerProperty, subContainer, -1, this.getEditorController());
            jobs.add(addPropertyJob);
        } else {
            List<Job> modifyChildrenJobs = this.modifyChildrenJobs(children);
            jobs.addAll(modifyChildrenJobs);
            List<Job> addChildrenJobs = this.addChildrenToPropertyJobs(tabContainerProperty, children);
            jobs.addAll(addChildrenJobs);
        }
        assert (tabContainerProperty.getParentInstance() == null);
        AddPropertyJob addTabContainerPropertyJob = new AddPropertyJob(tabContainerProperty, tabContainer, -1, this.getEditorController());
        jobs.add(addTabContainerPropertyJob);
        assert (newContainerProperty.getParentInstance() == null);
        AddPropertyJob addNewContainerPropertyJob = new AddPropertyJob(newContainerProperty, this.newContainer, -1, this.getEditorController());
        jobs.add(addNewContainerPropertyJob);
        return jobs;
    }

    @Override
    protected List<Job> modifyChildrenJobs(Set<FXOMObject> children) {
        return Collections.emptyList();
    }

    @Override
    protected void modifyContainer(Set<FXOMObject> children) {
    }
}

