/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job.wrap;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.ModifyObjectJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.Selection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.metadata.Metadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.Set;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class WrapJobUtils {
    static boolean canWrapIn(EditorController editorController) {
        Selection selection = editorController.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        if (!osg.hasSingleParent()) {
            return false;
        }
        if (!editorController.isSelectionNode()) {
            return false;
        }
        FXOMObject parent = osg.getAncestor();
        if (parent == null) {
            return true;
        }
        Object parentSceneGraphObject = parent.getSceneGraphObject();
        if (parentSceneGraphObject instanceof BorderPane) {
            return osg.getItems().size() == 1;
        }
        return !(parentSceneGraphObject instanceof Accordion) && !(parentSceneGraphObject instanceof TabPane);
    }

    static boolean canUnwrap(EditorController editorController) {
        int childrenCount;
        Selection selection = editorController.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        AbstractSelectionGroup asg = selection.getGroup();
        if (!(asg instanceof ObjectSelectionGroup)) {
            return false;
        }
        ObjectSelectionGroup osg = (ObjectSelectionGroup)asg;
        if (osg.getItems().size() != 1) {
            return false;
        }
        FXOMObject container = osg.getItems().iterator().next();
        if (!(container instanceof FXOMInstance)) {
            return false;
        }
        FXOMInstance containerInstance = (FXOMInstance)container;
        if (container.getSceneGraphObject() == null) {
            return false;
        }
        Class[] containerClasses = new Class[]{AnchorPane.class, GridPane.class, Group.class, HBox.class, ScrollPane.class, SplitPane.class, StackPane.class, TitledPane.class, ToolBar.class, VBox.class};
        boolean isAssignableFrom = false;
        for (Class clazz : containerClasses) {
            isAssignableFrom |= clazz.isAssignableFrom(containerInstance.getDeclaredClass());
        }
        boolean isPane = Pane.class.equals(containerInstance.getDeclaredClass());
        if (!isAssignableFrom && !isPane) {
            return false;
        }
        DesignHierarchyMask containerMask = new DesignHierarchyMask(container);
        if (containerMask.isAcceptingSubComponent()) {
            childrenCount = containerMask.getSubComponentCount();
        } else {
            assert (containerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT));
            int n = childrenCount = containerMask.getAccessoryProperty(DesignHierarchyMask.Accessory.CONTENT) == null ? 0 : 1;
        }
        if (childrenCount == 0) {
            return false;
        }
        FXOMObject parentContainer = container.getParentObject();
        if (parentContainer == null) {
            return childrenCount == 1;
        }
        DesignHierarchyMask parentContainerMask = new DesignHierarchyMask(parentContainer);
        if (parentContainerMask.isAcceptingSubComponent()) {
            return childrenCount >= 1;
        }
        assert (parentContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT) || parentContainerMask.isAcceptingAccessory(DesignHierarchyMask.Accessory.GRAPHIC) || parentContainerMask.getFxomObject().getSceneGraphObject() instanceof BorderPane);
        return childrenCount == 1;
    }

    static PropertyName getContainerPropertyName(FXOMInstance container, Set<FXOMObject> children) {
        PropertyName result;
        DesignHierarchyMask mask = new DesignHierarchyMask(container);
        if (mask.getFxomObject().getSceneGraphObject() instanceof BorderPane) {
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.TOP));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.LEFT));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CENTER));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.RIGHT));
            assert (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.BOTTOM));
            assert (children != null && children.size() == 1);
            FXOMObject child = children.iterator().next();
            FXOMObject top = mask.getAccessory(DesignHierarchyMask.Accessory.TOP);
            FXOMObject left = mask.getAccessory(DesignHierarchyMask.Accessory.LEFT);
            FXOMObject center = mask.getAccessory(DesignHierarchyMask.Accessory.CENTER);
            FXOMObject right = mask.getAccessory(DesignHierarchyMask.Accessory.RIGHT);
            FXOMObject bottom = mask.getAccessory(DesignHierarchyMask.Accessory.BOTTOM);
            if (child.equals(top)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.TOP);
            } else if (child.equals(bottom)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.BOTTOM);
            } else if (child.equals(center)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.CENTER);
            } else if (child.equals(left)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.LEFT);
            } else if (child.equals(right)) {
                result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.RIGHT);
            } else {
                assert (false);
                result = null;
            }
        } else if (mask.isAcceptingSubComponent()) {
            result = mask.getSubComponentPropertyName();
        } else if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.CONTENT)) {
            result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.CONTENT);
        } else if (mask.isAcceptingAccessory(DesignHierarchyMask.Accessory.GRAPHIC)) {
            result = mask.getPropertyNameForAccessory(DesignHierarchyMask.Accessory.GRAPHIC);
        } else {
            assert (false);
            result = null;
        }
        return result;
    }

    static Bounds getUnionOfBounds(Set<FXOMObject> fxomObjects) {
        assert (fxomObjects != null && !fxomObjects.isEmpty());
        Bounds result = null;
        for (FXOMObject fxomObject : fxomObjects) {
            Object scenegraphObject = fxomObject.getSceneGraphObject();
            assert (scenegraphObject instanceof Node);
            Node node = (Node)scenegraphObject;
            if (result == null) {
                result = node.getBoundsInParent();
                continue;
            }
            result = WrapJobUtils.getUnionOfBounds(result, node.getBoundsInParent());
        }
        return result;
    }

    static ModifyObjectJob modifyObjectJob(FXOMInstance instance, Class<?> clazz, String name, Object value, EditorController controller) {
        PropertyName pn = new PropertyName(name, clazz);
        ValuePropertyMetadata vpm = Metadata.getMetadata().queryValueProperty(instance, pn);
        ModifyObjectJob job = new ModifyObjectJob(instance, vpm, value, controller);
        return job;
    }

    static ModifyObjectJob modifyObjectJob(FXOMInstance instance, String name, Object value, EditorController controller) {
        return WrapJobUtils.modifyObjectJob(instance, null, name, value, controller);
    }

    private static Bounds getUnionOfBounds(Bounds ... bounds) {
        if (bounds == null || bounds.length == 0) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        if (bounds.length == 1) {
            return bounds[0];
        }
        Bounds b0 = bounds[0];
        for (int i = 1; i < bounds.length; ++i) {
            Bounds bi = bounds[i];
            if (bi == null) continue;
            b0 = WrapJobUtils.union(b0, bi);
        }
        return b0;
    }

    private static Bounds union(Bounds b1, Bounds b2) {
        double minX = Math.min(b1.getMinX(), b2.getMinX());
        double minY = Math.min(b1.getMinY(), b2.getMinY());
        double minZ = Math.min(b1.getMinZ(), b2.getMinZ());
        double maxX = Math.max(b1.getMaxX(), b2.getMaxX());
        double maxY = Math.max(b1.getMaxY(), b2.getMaxY());
        double maxZ = Math.max(b1.getMaxZ(), b2.getMaxZ());
        return new BoundingBox(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
    }
}

